/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demo_data;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.impl.WidgetUtils;
import com.epam.ta.reportportal.database.dao.DashboardRepository;
import com.epam.ta.reportportal.database.dao.UserFilterRepository;
import com.epam.ta.reportportal.database.dao.WidgetRepository;
import com.epam.ta.reportportal.database.entity.Dashboard;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.filter.SelectionOptions;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.database.entity.sharing.AclEntry;
import com.epam.ta.reportportal.database.entity.sharing.AclPermissions;
import com.epam.ta.reportportal.database.entity.widget.Widget;
import com.epam.ta.reportportal.database.search.Condition;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.demo_data.DemoDashboardsService;
import com.epam.ta.reportportal.demo_data.DemoDataRq;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
class DemoDashboardsService {
    static final String D_NAME = "DEMO DASHBOARD";
    static final String F_NAME = "DEMO_FILTER";
    private final UserFilterRepository userFilterRepository;
    private final DashboardRepository dashboardRepository;
    private final WidgetRepository widgetRepository;
    private final ObjectMapper objectMapper;
    private Resource resource;

    @Autowired
    DemoDashboardsService(UserFilterRepository userFilterRepository, DashboardRepository dashboardRepository, WidgetRepository widgetRepository, ObjectMapper objectMapper) {
        this.userFilterRepository = userFilterRepository;
        this.dashboardRepository = dashboardRepository;
        this.widgetRepository = widgetRepository;
        this.objectMapper = objectMapper;
    }

    @Value(value="classpath:demo/demo_widgets.json")
    public void setResource(Resource resource) {
        this.resource = resource;
    }

    Dashboard generate(DemoDataRq rq, String user, String project) {
        String dashboardName = "DEMO DASHBOARD#" + rq.getPostfix();
        String filterName = "DEMO_FILTER#" + rq.getPostfix();
        String filterId = this.createDemoFilter(filterName, user, project);
        List widgets = this.createWidgets(rq.getPostfix(), user, project, filterId);
        return this.createDemoDashboard(widgets, user, project, dashboardName);
    }

    List<Widget> createWidgets(String postfix, String user, String project, String filterId) {
        try {
            1 type = new /* Unavailable Anonymous Inner Class!! */;
            List existingWidgets = this.widgetRepository.findByProjectAndUser(project, user);
            List<Widget> widgets = ((List)this.objectMapper.readValue(this.resource.getURL(), (TypeReference)type)).stream().map(it -> {
                it.setProjectName(project);
                it.setApplyingFilterId(filterId);
                it.setAcl(DemoDashboardsService.acl((String)user, (String)project));
                String name = it.getName() + "#" + postfix;
                WidgetUtils.checkUniqueName((String)name, (List)existingWidgets);
                it.setName(name);
                return it;
            }).collect(Collectors.toList());
            this.widgetRepository.save(widgets);
            return widgets;
        }
        catch (IOException e) {
            throw new ReportPortalException("Unable to load demo_widgets.json. " + e.getMessage(), (Throwable)e);
        }
    }

    String createDemoFilter(String filterName, String user, String project) {
        UserFilter existingFilter = this.userFilterRepository.findOneByName(user, filterName, project);
        BusinessRule.expect((Object)existingFilter, (Predicate)Predicates.isNull()).verify(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{filterName});
        UserFilter userFilter = new UserFilter();
        userFilter.setName(filterName);
        userFilter.setFilter(new Filter(Launch.class, Condition.HAS, false, "demo", "tags"));
        SelectionOptions selectionOptions = new SelectionOptions();
        selectionOptions.setSortingColumnName("start_time");
        selectionOptions.setIsAsc(false);
        selectionOptions.setPageNumber(1);
        userFilter.setSelectionOptions(selectionOptions);
        userFilter.setProjectName(project);
        userFilter.setIsLink(false);
        userFilter.setAcl(DemoDashboardsService.acl((String)user, (String)project));
        return ((UserFilter)this.userFilterRepository.save((Object)userFilter)).getId();
    }

    Dashboard createDemoDashboard(List<Widget> widgets, String user, String project, String name) {
        Dashboard existing = this.dashboardRepository.findOneByUserProject(user, project, name);
        BusinessRule.expect((Object)existing, (Predicate)Predicates.isNull()).verify(ErrorType.RESOURCE_ALREADY_EXISTS, new Object[]{name});
        Dashboard dashboard = new Dashboard();
        dashboard.setName(name);
        ArrayList<Dashboard.WidgetObject> widgetObjects = new ArrayList<Dashboard.WidgetObject>();
        widgetObjects.add(new Dashboard.WidgetObject(widgets.get(0).getId(), Arrays.asList(6, 5), Arrays.asList(0, 0)));
        widgetObjects.add(new Dashboard.WidgetObject(widgets.get(1).getId(), Arrays.asList(6, 5), Arrays.asList(6, 0)));
        widgetObjects.add(new Dashboard.WidgetObject(widgets.get(2).getId(), Arrays.asList(6, 4), Arrays.asList(0, 5)));
        widgetObjects.add(new Dashboard.WidgetObject(widgets.get(3).getId(), Arrays.asList(7, 4), Arrays.asList(0, 9)));
        widgetObjects.add(new Dashboard.WidgetObject(widgets.get(4).getId(), Arrays.asList(6, 4), Arrays.asList(6, 5)));
        widgetObjects.add(new Dashboard.WidgetObject(widgets.get(5).getId(), Arrays.asList(5, 4), Arrays.asList(7, 9)));
        widgetObjects.add(new Dashboard.WidgetObject(widgets.get(6).getId(), Arrays.asList(7, 5), Arrays.asList(0, 13)));
        widgetObjects.add(new Dashboard.WidgetObject(widgets.get(7).getId(), Arrays.asList(5, 5), Arrays.asList(7, 13)));
        widgetObjects.add(new Dashboard.WidgetObject(widgets.get(8).getId(), Arrays.asList(12, 5), Arrays.asList(0, 18)));
        dashboard.setWidgets(widgetObjects);
        dashboard.setProjectName(project);
        dashboard.setCreationDate(new Date());
        dashboard.setAcl(DemoDashboardsService.acl((String)user, (String)project));
        return (Dashboard)this.dashboardRepository.save((Object)dashboard);
    }

    private static Acl acl(String user, String project) {
        Acl acl = new Acl();
        acl.setOwnerUserId(user);
        AclEntry aclEntry = new AclEntry();
        aclEntry.setPermissions(Collections.singleton(AclPermissions.READ));
        aclEntry.setProjectId(project);
        acl.setEntries(Collections.singleton(aclEntry));
        return acl;
    }
}

