/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demo_data;

import com.epam.ta.reportportal.core.statistics.StatisticsFacade;
import com.epam.ta.reportportal.core.statistics.StatisticsFacadeFactory;
import com.epam.ta.reportportal.core.statistics.StatisticsHelper;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.StatisticsCalculationStrategy;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.TestItemType;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssue;
import com.epam.ta.reportportal.database.entity.statistics.Statistics;
import java.io.Serializable;
import java.util.Date;
import java.util.Random;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
class DemoItemsService {
    private Random random = new Random();
    private TestItemRepository testItemRepository;
    private StatisticsFacadeFactory statisticsFacadeFactory;
    @Autowired
    @Qualifier(value="saveLogsTaskExecutor")
    private TaskExecutor taskExecutor;

    @Autowired
    DemoItemsService(TestItemRepository testItemRepository, StatisticsFacadeFactory statisticsFacadeFactory) {
        this.testItemRepository = testItemRepository;
        this.statisticsFacadeFactory = statisticsFacadeFactory;
    }

    void finishTestItem(String testItemId, String status) {
        TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)testItemId));
        if ("FAILED".equals(status) && !this.hasChildren(testItem.getType())) {
            testItem.setIssue(new TestItemIssue(this.issueType(), null));
        }
        testItem.setStatus((Status)Status.fromValue((String)status).get());
        testItem.setEndTime(new Date());
        this.testItemRepository.save((Object)testItem);
        TestItemType testItemType = testItem.getType();
        this.taskExecutor.execute(() -> {
            if (!this.hasChildren(testItemType)) {
                StatisticsFacade statisticsFacade = this.statisticsFacadeFactory.getStatisticsFacade(StatisticsCalculationStrategy.TEST_BASED);
                statisticsFacade.updateExecutionStatistics(testItem);
                if (null != testItem.getIssue()) {
                    statisticsFacade.updateIssueStatistics(testItem);
                }
            }
        });
    }

    TestItem startTestItem(TestItem rootItemId, String launchId, String name, TestItemType testItemType) {
        TestItem testItem = new TestItem();
        testItem.setLaunchRef(launchId);
        testItem.setStartTime(new Date());
        testItem.setName(name);
        testItem.setParent(rootItemId.getId());
        testItem.setHasChilds(this.hasChildren(testItemType));
        testItem.setStatus(Status.IN_PROGRESS);
        testItem.setType(testItemType);
        testItem.getPath().addAll(rootItemId.getPath());
        testItem.getPath().add(rootItemId.getId());
        return (TestItem)this.testItemRepository.save((Object)testItem);
    }

    boolean hasChildren(TestItemType testItemType) {
        return testItemType != TestItemType.STEP && testItemType != TestItemType.BEFORE_CLASS && testItemType != TestItemType.BEFORE_METHOD && testItemType != TestItemType.AFTER_CLASS && testItemType != TestItemType.AFTER_METHOD;
    }

    TestItem startRootItem(String rootItemName, String launchId) {
        TestItem testItem = new TestItem();
        testItem.setLaunchRef(launchId);
        testItem.setStartTime(new Date());
        testItem.setName(rootItemName);
        testItem.setHasChilds(true);
        testItem.setStatus(Status.IN_PROGRESS);
        testItem.setType(TestItemType.SUITE);
        return (TestItem)this.testItemRepository.save((Object)testItem);
    }

    void finishRootItem(String rootItemId) {
        TestItem testItem = (TestItem)this.testItemRepository.findOne((Serializable)((Object)rootItemId));
        testItem.setEndTime(new Date());
        testItem.setStatus(StatisticsHelper.getStatusFromStatistics((Statistics)testItem.getStatistics()));
        this.testItemRepository.save((Object)testItem);
    }

    private String issueType() {
        int value = this.random.nextInt(100);
        if (value < 25) {
            return "PB001";
        }
        if (value < 50) {
            return "AB001";
        }
        if (value < 75) {
            return "SI001";
        }
        return "TI001";
    }
}

