/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demo_data;

import com.epam.ta.reportportal.core.statistics.StatisticsHelper;
import com.epam.ta.reportportal.database.dao.LaunchMetaInfoRepository;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.TestItemType;
import com.epam.ta.reportportal.database.entity.statistics.Statistics;
import com.epam.ta.reportportal.demo_data.DemoDataRq;
import com.epam.ta.reportportal.demo_data.DemoItemsService;
import com.epam.ta.reportportal.demo_data.DemoLogsService;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
class DemoLaunchesService {
    static final String NAME = "Demo Api Tests";
    private Random random = new Random();
    @Autowired
    private DemoLogsService logDemoDataService;
    @Autowired
    private DemoItemsService demoItemsService;
    @Autowired
    private LaunchRepository launchRepository;
    @Autowired
    private LaunchMetaInfoRepository launchCounter;
    @Value(value="classpath:demo/demo_data.json")
    private Resource resource;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    @Qualifier(value="saveLogsTaskExecutor")
    private TaskExecutor taskExecutor;

    DemoLaunchesService() {
    }

    List<String> generateDemoLaunches(DemoDataRq demoDataRq, String user, String projectName) {
        Map suites;
        try {
            suites = (Map)this.objectMapper.readValue(this.resource.getURL(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            throw new ReportPortalException("Unable to load suites description. " + e.getMessage(), (Throwable)e);
        }
        return this.generateLaunches(demoDataRq, suites, user, projectName);
    }

    private List<String> generateLaunches(DemoDataRq rq, Map<String, Map<String, List<String>>> suitesStructure, String user, String project) {
        return IntStream.range(0, rq.getLaunchesQuantity()).mapToObj(i -> {
            String launchId = this.startLaunch("Demo Api Tests_" + rq.getPostfix(), i, project, user);
            this.generateSuites(suitesStructure, i, launchId);
            this.finishLaunch(launchId);
            return launchId;
        }).collect(Collectors.toList());
    }

    private List<String> generateSuites(Map<String, Map<String, List<String>>> suitesStructure, int i, String launchId) {
        return suitesStructure.entrySet().parallelStream().limit(i + 1).map(suites -> {
            TestItem suiteItem = this.demoItemsService.startRootItem((String)suites.getKey(), launchId);
            ((Map)suites.getValue()).entrySet().forEach(tests -> {
                TestItem testItem = this.demoItemsService.startTestItem(suiteItem, launchId, (String)tests.getKey(), TestItemType.TEST);
                String beforeClassStatus = "";
                if (this.random.nextBoolean()) {
                    TestItem beforeClass = this.demoItemsService.startTestItem(testItem, launchId, "beforeClass", TestItemType.BEFORE_CLASS);
                    beforeClassStatus = this.beforeClassStatus();
                    this.demoItemsService.finishTestItem(beforeClass.getId(), beforeClassStatus);
                }
                boolean isGenerateBeforeMethod = this.random.nextBoolean();
                boolean isGenerateAfterMethod = this.random.nextBoolean();
                ((List)tests.getValue()).stream().limit(i + 1).forEach(name -> {
                    if (isGenerateBeforeMethod) {
                        this.demoItemsService.finishTestItem(this.demoItemsService.startTestItem(testItem, launchId, "beforeMethod", TestItemType.BEFORE_METHOD).getId(), this.status());
                    }
                    TestItem stepId = this.demoItemsService.startTestItem(testItem, launchId, name, TestItemType.STEP);
                    String status = this.status();
                    this.taskExecutor.execute(() -> {
                        this.logDemoDataService.generateDemoLogs(stepId.getId(), status);
                        this.demoItemsService.finishTestItem(stepId.getId(), status);
                        if (isGenerateAfterMethod) {
                            this.demoItemsService.finishTestItem(this.demoItemsService.startTestItem(testItem, launchId, "afterMethod", TestItemType.AFTER_METHOD).getId(), this.status());
                        }
                    });
                });
                if (this.random.nextBoolean()) {
                    TestItem afterClass = this.demoItemsService.startTestItem(testItem, launchId, "afterClass", TestItemType.AFTER_CLASS);
                    this.demoItemsService.finishTestItem(afterClass.getId(), this.status());
                }
                this.demoItemsService.finishTestItem(testItem.getId(), !beforeClassStatus.isEmpty() ? beforeClassStatus : "FAILED");
            });
            this.demoItemsService.finishRootItem(suiteItem.getId());
            return suiteItem.getId();
        }).collect(Collectors.toList());
    }

    private String startLaunch(String name, int i, String project, String user) {
        Launch launch = new Launch();
        launch.setName(name);
        launch.setDescription("Demo Launch");
        launch.setStartTime(new Date());
        launch.setTags(new HashSet<String>(Arrays.asList("desktop", "demo", "build:3.0.1." + (i + 1))));
        launch.setStatus(Status.IN_PROGRESS);
        launch.setUserRef(user);
        launch.setProjectRef(project);
        launch.setNumber(Long.valueOf(this.launchCounter.getLaunchNumber(name, project)));
        launch.setMode(Mode.DEFAULT);
        return ((Launch)this.launchRepository.save((Object)launch)).getId();
    }

    private String status() {
        int value = this.random.nextInt(71);
        if (value <= 5) {
            return Status.SKIPPED.name();
        }
        if (value <= 48) {
            return Status.PASSED.name();
        }
        return Status.FAILED.name();
    }

    private String beforeClassStatus() {
        int value = this.random.nextInt(71);
        if (value <= 3) {
            return Status.SKIPPED.name();
        }
        if (value <= 62) {
            return Status.PASSED.name();
        }
        return Status.FAILED.name();
    }

    private void finishLaunch(String launchId) {
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launchId));
        launch.setEndTime(new Date());
        launch.setStatus(StatisticsHelper.getStatusFromStatistics((Statistics)launch.getStatistics()));
        this.launchRepository.save((Object)launch);
    }
}

