/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.commons.Constants;
import com.epam.ta.reportportal.database.BinaryData;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.ServerSettingsRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.ServerSettings;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.database.entity.user.UserType;
import com.epam.ta.reportportal.database.personal.PersonalProjectUtils;
import com.epam.ta.reportportal.ws.model.settings.ServerEmailConfig;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.io.Serializable;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
public class AddDemoProjectEventHandler
implements ApplicationListener<ContextRefreshedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AddDemoProjectEventHandler.class);
    private static final AtomicBoolean IMPORTED_FLAG = new AtomicBoolean(false);
    private static final String DEFAULT_PROFILE_ID = "default";
    @Value(value="${rp.email.server}")
    private String host;
    @Value(value="${rp.email.port}")
    private int port;
    @Value(value="${rp.email.protocol}")
    private String protocol;
    @Value(value="${rp.email.account}")
    private String username;
    @Value(value="${rp.email.password}")
    private String password;
    @Value(value="${rp.email.from}")
    private String addressFrom;
    @Value(value="${rp.email.auth:false}")
    private boolean isEnable;
    @Value(value="${rp.email.debug:false}")
    private boolean isDebug;
    public static final Supplier<BinaryData> NONAME_USER_PHOTO = Suppliers.memoize(() -> new BinaryData("image/jpeg", null, AddDemoProjectEventHandler.class.getClassLoader().getResourceAsStream("nonameUserPhoto.jpg")));
    public static final Supplier<BinaryData> DEMO_USER_PHOTO = Suppliers.memoize(() -> new BinaryData("image/jpeg", null, AddDemoProjectEventHandler.class.getClassLoader().getResourceAsStream("defaultUserPhoto.jpg")));
    public static final Supplier<BinaryData> DEFAULT_ADMIN_PHOTO = Suppliers.memoize(() -> new BinaryData("image/jpeg", null, AddDemoProjectEventHandler.class.getClassLoader().getResourceAsStream("superAdminPhoto.jpg")));
    public static final Supplier<User> DEFAULT_ADMIN = Suppliers.memoize(() -> {
        LOGGER.info("========== DEFAULT ADMINISTRATOR CREATION ==========");
        User user = new User();
        user.setLogin(Constants.DEFAULT_ADMIN.toString());
        user.setPassword(Constants.DEFAULT_ADMIN_PASS.toString());
        user.setType(UserType.INTERNAL);
        user.setEmail("defaultadministrator@example.com");
        user.setFullName("RP Admin");
        user.setDefaultProject(PersonalProjectUtils.personalProjectName((String)user.getLogin()));
        user.setIsExpired(false);
        user.getMetaInfo().setLastLogin(Calendar.getInstance().getTime());
        user.setRole(UserRole.ADMINISTRATOR);
        return user;
    });
    public static final Supplier<User> DEFAULT_USER = Suppliers.memoize(() -> {
        LOGGER.info("========== DEFAULT USER CREATION ==========");
        User user = new User();
        user.setLogin(Constants.DEFAULT_USER.toString());
        user.setPassword(Constants.DEFAULT_USER_PASS.toString());
        user.setType(UserType.INTERNAL);
        user.setEmail("defaulttester@example.com");
        user.setFullName("RP Tester");
        user.setDefaultProject(PersonalProjectUtils.personalProjectName((String)user.getLogin()));
        user.setIsExpired(false);
        user.getMetaInfo().setLastLogin(Calendar.getInstance().getTime());
        user.setRole(UserRole.USER);
        return user;
    });
    public final Supplier<ServerSettings> DEFAULT_PROFILE = Suppliers.memoize(() -> {
        LOGGER.info("======= DEFAULT SERVER PROFILE CREATION =======");
        ServerSettings settings = new ServerSettings();
        settings.setId(DEFAULT_PROFILE_ID);
        settings.setActive(true);
        settings.setServerEmailConfig(new ServerEmailConfig(this.host, this.port, this.protocol, Boolean.valueOf(this.isEnable), false, false, this.username, this.password, this.isDebug));
        return settings;
    });
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private ServerSettingsRepository serverSettingsRepository;

    public void onApplicationEvent(ContextRefreshedEvent event) {
        if (IMPORTED_FLAG.compareAndSet(false, true)) {
            String photoId;
            User user;
            this.userRepository.uploadUserPhoto(Constants.NONAME_USER.toString(), (BinaryData)NONAME_USER_PHOTO.get());
            if (null == this.userRepository.findOne(((User)DEFAULT_ADMIN.get()).getLogin())) {
                user = (User)DEFAULT_ADMIN.get();
                photoId = this.userRepository.uploadUserPhoto(user.getLogin(), (BinaryData)DEFAULT_ADMIN_PHOTO.get());
                user.setPhotoId(photoId);
                this.projectRepository.save(PersonalProjectUtils.generatePersonalProject((User)user));
                this.userRepository.save(user);
            }
            if (null == this.userRepository.findOne(((User)DEFAULT_USER.get()).getLogin())) {
                user = (User)DEFAULT_USER.get();
                photoId = this.userRepository.uploadUserPhoto(user.getLogin(), (BinaryData)DEMO_USER_PHOTO.get());
                user.setPhotoId(photoId);
                this.projectRepository.save(PersonalProjectUtils.generatePersonalProject((User)user));
                this.userRepository.save(user);
            }
            if (null == this.serverSettingsRepository.findOne((Serializable)((Object)((ServerSettings)this.DEFAULT_PROFILE.get()).getId()))) {
                this.serverSettingsRepository.save(this.DEFAULT_PROFILE.get());
            }
        }
    }
}

