/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.entity.ExternalSystem;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.events.ExternalSystemCreatedEvent;
import com.epam.ta.reportportal.events.ExternalSystemDeletedEvent;
import com.epam.ta.reportportal.events.ExternalSystemUpdatedEvent;
import com.epam.ta.reportportal.events.ProjectExternalSystemsDeletedEvent;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ExternalSystemActivityHandler {
    public static final String EXTERNAL_SYSTEM = "externalSystem";
    public static final String DELETE = "delete_bts";
    public static final String UPDATE = "update_bts";
    public static final String CREATE = "create_bts";
    private final ActivityRepository activityRepository;
    private final Provider<ActivityBuilder> activityBuilder;

    @Autowired
    public ExternalSystemActivityHandler(ActivityRepository activityRepository, Provider<ActivityBuilder> activityBuilder) {
        this.activityRepository = activityRepository;
        this.activityBuilder = activityBuilder;
    }

    @EventListener
    public void onExternalSystemCreated(ExternalSystemCreatedEvent event) {
        ExternalSystem externalSystem = event.getExternalSystem();
        String name = externalSystem.getExternalSystemType().name() + ":" + externalSystem.getProject();
        Activity activity = (Activity)((ActivityBuilder)this.activityBuilder.get()).addObjectName(name).addObjectType(EXTERNAL_SYSTEM).addLoggedObjectRef(externalSystem.getId()).addUserRef(event.getCreatedBy()).addActionType(CREATE).addProjectRef(externalSystem.getProjectRef()).build();
        this.activityRepository.save((Object)activity);
    }

    @EventListener
    public void onExternalSystemUpdate(ExternalSystemUpdatedEvent event) {
        ExternalSystem externalSystem = event.getExternalSystem();
        if (externalSystem != null) {
            String name = externalSystem.getExternalSystemType().name() + ":" + externalSystem.getProject();
            Activity activity = (Activity)((ActivityBuilder)this.activityBuilder.get()).addObjectName(name).addObjectType(EXTERNAL_SYSTEM).addLoggedObjectRef(externalSystem.getId()).addUserRef(event.getUpdatedBy()).addActionType(UPDATE).addProjectRef(externalSystem.getProjectRef()).build();
            this.activityRepository.save((Object)activity);
        }
    }

    @EventListener
    public void onExternalSystemDelete(ExternalSystemDeletedEvent event) {
        ExternalSystem externalSystem = event.getExternalSystem();
        if (externalSystem != null) {
            String name = externalSystem.getExternalSystemType().name() + ":" + externalSystem.getProject();
            Activity activity = (Activity)((ActivityBuilder)this.activityBuilder.get()).addObjectName(name).addObjectType(EXTERNAL_SYSTEM).addLoggedObjectRef(externalSystem.getId()).addUserRef(event.getDeletedBy()).addActionType(DELETE).addProjectRef(externalSystem.getProjectRef()).build();
            this.activityRepository.save((Object)activity);
        }
    }

    @EventListener
    public void onProjectExternalSystemsDelete(ProjectExternalSystemsDeletedEvent event) {
        List activities;
        Iterable externalSystems = event.getExternalSystems();
        if (null != externalSystems && !(activities = StreamSupport.stream(externalSystems.spliterator(), false).map(externalSystem -> {
            String name = externalSystem.getExternalSystemType().name() + ":" + externalSystem.getProject();
            return (Activity)((ActivityBuilder)this.activityBuilder.get()).addObjectName(name).addObjectType(EXTERNAL_SYSTEM).addLoggedObjectRef(externalSystem.getId()).addUserRef(event.getDeletedBy()).addActionType(DELETE).addProjectRef(event.getProject()).build();
        }).collect(Collectors.toList())).isEmpty()) {
            this.activityRepository.save(activities);
        }
    }
}

