/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.events.LaunchDeletedEvent;
import com.epam.ta.reportportal.events.LaunchFinishForcedEvent;
import com.epam.ta.reportportal.events.LaunchFinishedEvent;
import com.epam.ta.reportportal.events.LaunchStartedEvent;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class LaunchActivityHandler {
    private static final String DELIMITER = " #";
    public static final String START = "start";
    public static final String FINISH = "finish";
    public static final String DELETE = "delete";
    private final Provider<ActivityBuilder> activityBuilder;
    private final ActivityRepository activityRepository;

    @Autowired
    public LaunchActivityHandler(Provider<ActivityBuilder> activityBuilder, ActivityRepository activityRepository) {
        this.activityBuilder = activityBuilder;
        this.activityRepository = activityRepository;
    }

    @EventListener
    public void onLaunchFinish(LaunchFinishedEvent event) {
        this.afterLaunchFinished(event.getLaunch(), event.getLaunch().getUserRef());
    }

    @EventListener
    public void onLaunchForceFinish(LaunchFinishForcedEvent event) {
        this.afterLaunchFinished(event.getLaunch(), event.getForcedBy());
    }

    @EventListener
    public void onLaunchStart(LaunchStartedEvent event) {
        Launch launch = event.getLaunch();
        if (Mode.DEBUG != event.getLaunch().getMode()) {
            String name = launch.getName() + DELIMITER + launch.getNumber();
            Activity activityLog = (Activity)((ActivityBuilder)this.activityBuilder.get()).addUserRef(launch.getUserRef()).addProjectRef(launch.getProjectRef().toLowerCase()).addActionType(START).addObjectType("launch").addLoggedObjectRef(launch.getId()).addObjectName(name).build();
            this.activityRepository.save((Object)activityLog);
        }
    }

    @EventListener
    public void onDeleteLaunch(LaunchDeletedEvent event) {
        Launch launch = event.getLaunch();
        if (null != launch && launch.getMode() == Mode.DEFAULT) {
            String name = launch.getName() + DELIMITER + launch.getNumber();
            Activity activity = (Activity)((ActivityBuilder)this.activityBuilder.get()).addUserRef(event.getDeletedBy()).addProjectRef(event.getLaunch().getProjectRef()).addActionType(DELETE).addObjectType("launch").addLoggedObjectRef(launch.getId()).addObjectName(name).build();
            this.activityRepository.save((Object)activity);
        }
    }

    private void afterLaunchFinished(Launch launch, String finishedBy) {
        if (launch.getMode() != Mode.DEBUG) {
            String name = launch.getName() + DELIMITER + launch.getNumber();
            Activity activityLog = (Activity)((ActivityBuilder)this.activityBuilder.get()).addUserRef(finishedBy).addProjectRef(launch.getProjectRef()).addActionType(FINISH).addObjectType("launch").addLoggedObjectRef(launch.getId()).addObjectName(name).build();
            this.activityRepository.save((Object)activityLog);
        }
    }
}

