/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.database.Time;
import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.project.KeepLogsDelay;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class CleanLogsJob
implements Runnable {
    @Autowired
    private LogRepository logRepo;
    @Autowired
    private LaunchRepository launchRepo;
    @Autowired
    private TestItemRepository testItemRepo;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private ActivityRepository activityRepository;

    @Override
    @Scheduled(cron="${com.ta.reportportal.job.clean.logs.cron}")
    public void run() {
        this.projectRepository.findAll().forEach(project -> {
            Time period = Time.days((long)KeepLogsDelay.findByName((String)project.getConfiguration().getKeepLogs()).getDays());
            this.activityRepository.deleteModifiedLaterAgo(project.getId(), period);
            this.removeOutdatedLogs(project.getId(), period);
        });
    }

    private void removeOutdatedLogs(String projectId, Time period) {
        this.launchRepo.findLaunchIdsByProjectId(projectId).stream().map(launch -> this.testItemRepo.findIdsByLaunch(launch.getId())).map(testItems -> this.logRepo.findModifiedLaterAgo(period, (Iterable)testItems)).forEach(logs -> this.logRepo.delete((Iterable)logs));
    }
}

