/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.database.DataStorage;
import com.epam.ta.reportportal.database.Time;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.project.KeepScreenshotsDelay;
import com.epam.ta.reportportal.exception.ReportPortalException;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class CleanScreenshotsJob
implements Runnable {
    static final String PHOTO_PREFIX = "photo_";
    @Autowired
    private DataStorage gridFS;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private LogRepository logRepository;

    @Override
    @Scheduled(cron="${com.ta.reportportal.job.clean.screenshots.cron}")
    public void run() {
        List projects = this.projectRepository.findAll();
        for (Project project : projects) {
            Time period = Time.days((long)KeepScreenshotsDelay.findByName((String)project.getConfiguration().getKeepScreenshots()).getDays());
            List files = this.gridFS.findModifiedLaterAgo(period, project.getId());
            files.stream().filter(file -> !file.getFilename().startsWith(PHOTO_PREFIX)).forEach(file -> {
                this.gridFS.deleteData(file.getId().toString());
                this.clearLogsBinaryContent(file.getId().toString());
            });
        }
    }

    private void clearLogsBinaryContent(String fileId) {
        List logList = this.logRepository.findLogsByFileId(fileId).stream().map(log -> {
            log.setBinaryContent(null);
            return log;
        }).collect(Collectors.toList());
        try {
            this.logRepository.save(logList);
        }
        catch (Exception e) {
            throw new ReportPortalException("Exception during update binary content field of Log item", (Throwable)e);
        }
    }
}

