/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.core.statistics.StatisticsFacadeFactory;
import com.epam.ta.reportportal.database.Time;
import com.epam.ta.reportportal.database.dao.FailReferenceResourceRepository;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.project.InterruptionJobDelay;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class InterruptBrokenLaunchesJob
implements Runnable {
    @Autowired
    private LaunchRepository launchRepository;
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private LogRepository logRepository;
    @Autowired
    private FailReferenceResourceRepository issuesRepository;
    @Autowired
    private StatisticsFacadeFactory statisticsFacadeFactory;
    @Autowired
    private ProjectRepository projectRepository;

    @Override
    @Scheduled(cron="${com.ta.reportportal.job.interrupt.broken.launches.cron}")
    public void run() {
        List projects = this.projectRepository.findAll();
        for (Project project : projects) {
            Time maxDuration = Time.hours((long)InterruptionJobDelay.findByName((String)project.getConfiguration().getInterruptJobTime()).getPeriod());
            List launches = this.launchRepository.findModifiedLaterAgo(maxDuration, Status.IN_PROGRESS, project.getId());
            for (Launch launch : launches) {
                if (!this.launchRepository.hasItems(launch, Status.IN_PROGRESS)) {
                    this.interruptLaunches(Collections.singletonList(launch));
                    continue;
                }
                if (this.testItemRepository.hasTestItemsAddedLately(maxDuration, launch, Status.IN_PROGRESS)) continue;
                List items = this.testItemRepository.findModifiedLaterAgo(maxDuration, Status.IN_PROGRESS, launch);
                if (this.testItemRepository.hasLogs((Iterable)items)) {
                    boolean isLaunchBroken = true;
                    for (TestItem item : items) {
                        if (!this.logRepository.hasLogsAddedLately(maxDuration, item)) continue;
                        isLaunchBroken = false;
                        break;
                    }
                    if (!isLaunchBroken) continue;
                    this.interruptItems(this.testItemRepository.findInStatusItems(Status.IN_PROGRESS.name(), launch.getId()), launch);
                    continue;
                }
                List itemsInProgress = this.testItemRepository.findInStatusItems(Status.IN_PROGRESS.name(), launch.getId());
                this.interruptItems(itemsInProgress, launch);
            }
        }
    }

    private void interruptLaunches(List<Launch> launches) {
        for (Launch launch : launches) {
            launch.setStatus(Status.INTERRUPTED);
            launch.setEndTime(Calendar.getInstance().getTime());
            this.launchRepository.save((Object)launch);
            this.clearIssueReferences(launch.getId());
        }
    }

    private void interruptItems(List<TestItem> testItems, Launch launch) {
        if (testItems.isEmpty()) {
            return;
        }
        testItems.forEach(arg_0 -> this.interruptItem(arg_0));
        Launch launchReloaded = (Launch)this.launchRepository.findOne((Serializable)((Object)launch.getId()));
        launchReloaded.setStatus(Status.INTERRUPTED);
        launchReloaded.setEndTime(Calendar.getInstance().getTime());
        this.launchRepository.save((Object)launchReloaded);
        this.clearIssueReferences(launch.getId());
    }

    private void clearIssueReferences(String launchId) {
        List issues = this.issuesRepository.findAllLaunchIssues(launchId);
        this.issuesRepository.delete((Iterable)issues);
    }

    private void interruptItem(TestItem item) {
        if (!Status.INTERRUPTED.equals((Object)item.getStatus())) {
            Project project;
            item.setStatus(Status.INTERRUPTED);
            item.setEndTime(Calendar.getInstance().getTime());
            item = (TestItem)this.testItemRepository.save((Object)item);
            if (!item.hasChilds() && null != (item = this.statisticsFacadeFactory.getStatisticsFacade((project = (Project)this.projectRepository.findOne((Serializable)((Object)((Launch)this.launchRepository.findOne((Serializable)((Object)item.getLaunchRef()))).getProjectRef()))).getConfiguration().getStatisticsCalculationStrategy()).updateExecutionStatistics(item)).getIssue()) {
                item = this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy()).updateIssueStatistics(item);
            }
            if (null != item.getParent()) {
                this.interruptItem((TestItem)this.testItemRepository.findOne((Serializable)((Object)item.getParent())));
            }
        }
    }
}

