/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util;

import com.epam.ta.reportportal.util.LazyReference;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class LazyReference<T>
implements ApplicationContextAware {
    private FindBeanStrategy<T> beanFindStrategy;
    private Supplier<T> supplier;

    public LazyReference(Class<T> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"Bean class shouldn't be null");
        this.beanFindStrategy = new ByClassFindStrategy(clazz);
    }

    public LazyReference(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0, (Object)"Bean name shouldn't be null");
        this.beanFindStrategy = new ByNameFindStrategy(name);
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.supplier = this.createBeanSupplier(context);
    }

    public T get() {
        return (T)this.supplier.get();
    }

    protected Supplier<T> createBeanSupplier(ApplicationContext context) {
        return () -> this.getBeanFromContext(context);
    }

    private T getBeanFromContext(ApplicationContext context) {
        return (T)this.beanFindStrategy.findBean(context);
    }
}

