/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util.analyzer;

import com.epam.ta.reportportal.core.item.history.ITestItemsHistoryService;
import com.epam.ta.reportportal.core.statistics.StatisticsFacadeFactory;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Log;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssue;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssueType;
import com.epam.ta.reportportal.util.analyzer.CacheElementEnum;
import com.epam.ta.reportportal.util.analyzer.IIssuesAnalyzer;
import com.google.common.base.Strings;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="analyzerService")
public class IssuesAnalyzerService
implements IIssuesAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(IssuesAnalyzerService.class);
    private static final String MARKER = "AUTO-SYSTEM";
    private static final int MAXIMUM_SIZE = 10000;
    private static final int CACHE_ITEM_LIVE = 1440;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private LaunchRepository launchRepository;
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private LogRepository logRepository;
    @Autowired
    private ITestItemsHistoryService historyServiceStrategy;
    @Autowired
    private StatisticsFacadeFactory statisticsFacadeFactory;
    @Value(value="${rp.issue.analyzer.rate}")
    private double acceptRate;
    private LoadingCache<String, String> processingIds = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(1440L, TimeUnit.MINUTES).build((CacheLoader)new /* Unavailable Anonymous Inner Class!! */);

    public List<TestItem> collectPreviousIssues(int depth, String launchId, String projectName) {
        this.processingIds.put((Object)launchId, (Object)CacheElementEnum.STARTED.name());
        List launchHistory = this.historyServiceStrategy.loadLaunches(depth, launchId, projectName, false);
        return launchHistory.stream().flatMap(launch -> this.testItemRepository.findTestItemWithInvestigated(launch.getId()).stream()).collect(Collectors.toList());
    }

    public void analyze(String launchId, List<TestItem> resources, List<TestItem> scope) {
        for (TestItem current : resources) {
            ArrayList curRate = Lists.newArrayList();
            TestItemIssue issue = null;
            boolean isInvestigated = false;
            List curItemErr = this.logRepository.findTestItemErrorLogs(current.getId());
            Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)current.getLaunchRef()));
            Project project = (Project)this.projectRepository.findOne((Serializable)((Object)launch.getProjectRef()));
            for (TestItem item : scope) {
                if (item.getId().equalsIgnoreCase(current.getId())) continue;
                List errors = this.logRepository.findTestItemErrorLogs(item.getId());
                if (errors.size() == curItemErr.size()) {
                    for (int i = 0; i < curItemErr.size(); ++i) {
                        String curMsg = ((Log)curItemErr.get(i)).getLogMsg().replaceAll("\\d+", "").replaceAll("\\s(at)\\s", "");
                        String scopeMsg = ((Log)errors.get(i)).getLogMsg().replaceAll("\\d+", "").replaceAll("\\s(at)\\s", "");
                        int maxString = Math.max(curMsg.length(), scopeMsg.length());
                        int diff = StringUtils.getLevenshteinDistance((CharSequence)curMsg, (CharSequence)scopeMsg);
                        curRate.add((double)(maxString - diff) / (double)maxString * 100.0);
                    }
                }
                if (!curRate.isEmpty() && this.mathMiddle((List)curRate) >= this.acceptRate) {
                    isInvestigated = true;
                    issue = item.getIssue();
                    break;
                }
                curRate.clear();
            }
            if (!isInvestigated) continue;
            TestItemIssue currentIssue = current.getIssue();
            if (null != currentIssue.getExternalSystemIssues() || !currentIssue.getIssueType().equalsIgnoreCase(TestItemIssueType.TO_INVESTIGATE.getLocator()) || null != currentIssue.getIssueDescription()) {
                currentIssue.setIssueDescription(this.suggest(currentIssue.getIssueDescription(), issue, project.getConfiguration()));
                current.setIssue(currentIssue);
                this.testItemRepository.save((Object)current);
                continue;
            }
            issue.setIssueDescription(this.mark(issue.getIssueDescription()));
            current = this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy()).resetIssueStatistics(current);
            current.setIssue(issue);
            this.testItemRepository.save((Object)current);
            this.statisticsFacadeFactory.getStatisticsFacade(project.getConfiguration().getStatisticsCalculationStrategy()).updateIssueStatistics(current);
        }
        this.analyzeFinished(launchId);
    }

    public boolean isPossible(String key) {
        String value = (String)this.processingIds.getIfPresent((Object)key);
        return Strings.isNullOrEmpty((String)value) || CacheElementEnum.FINISHED.name().equalsIgnoreCase(value);
    }

    public void analyzeFinished(String key) {
        this.processingIds.put((Object)key, (Object)CacheElementEnum.FINISHED.name());
        this.processingIds.invalidate((Object)key);
    }

    public boolean analyzeStarted(String key) {
        try {
            this.processingIds.put((Object)key, (Object)CacheElementEnum.STARTED.name());
            return true;
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    private double mathMiddle(List<Double> rates) {
        double sum = 0.0;
        for (double i : rates) {
            sum += i;
        }
        return sum / (double)rates.size();
    }

    private String mark(String description) {
        StringBuilder builder = new StringBuilder(MARKER);
        return null != description ? builder.append("\n\n").append(this.markerNullifier(description)).toString() : builder.toString();
    }

    private String suggest(String currentDescription, TestItemIssue previousIssue, Project.Configuration settings) {
        StringBuilder builder = new StringBuilder();
        if (null != currentDescription) {
            builder.append(currentDescription);
        }
        StringBuilder ticketIds = new StringBuilder();
        if (null != previousIssue.getExternalSystemIssues()) {
            for (TestItemIssue.ExternalSystemIssue externalSystemIssue : previousIssue.getExternalSystemIssues()) {
                ticketIds.append(externalSystemIssue.getTicketId()).append(",");
            }
            if (ticketIds.length() > 0) {
                ticketIds.deleteCharAt(ticketIds.length() - 1);
            } else {
                ticketIds.append("");
            }
        }
        builder.append("\n").append(MARKER).append("\n\n").append(" Similar issue has been found in history as:").append("\n").append("*IssueType:* ").append(settings.getByLocator(previousIssue.getIssueType()).getLongName()).append("\n").append("*TicketIds:* ").append(ticketIds.toString()).append("\n");
        return null != previousIssue.getIssueDescription() ? builder.append("*IssueDescription:* ").append("\n").append(previousIssue.getIssueDescription()).toString() : builder.toString();
    }

    private String markerNullifier(String description) {
        description = description.replaceAll(MARKER.concat("\n\n"), "");
        description = description.replaceAll(MARKER.concat("\n"), "");
        description = description.replaceAll(MARKER, "");
        return description;
    }

    public void setProcessingIds(LoadingCache<String, String> cache) {
        this.processingIds = cache;
    }

    public LoadingCache<String, String> getProcessIds() {
        return this.processingIds;
    }
}

