/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util.email;

import com.epam.reportportal.commons.template.TemplateEngine;
import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.ws.model.user.CreateUserRQFull;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;

public class EmailService
extends JavaMailSenderImpl {
    private static final String FINISH_LAUNCH_EMAIL_SUBJECT = " Report Portal Notification: launch '%s' #%s finished";
    private static final String LOGO = "templates/email/rp_logo.png";
    private TemplateEngine templateEngine;
    private static final String RP_EMAIL = "ReportPortal@service.com";
    private String addressFrom = "ReportPortal@service.com";

    public EmailService(Properties javaMailProperties) {
        super.setJavaMailProperties(javaMailProperties);
    }

    public void sendConfirmationEmail(String subject, String[] recipients, String url) {
        MimeMessagePreparator preparator = mimeMessage -> {
            URL logoImg = this.getClass().getClassLoader().getResource(LOGO);
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject(subject);
            message.setTo(recipients);
            message.setFrom(RP_EMAIL);
            HashMap<String, String> email = new HashMap<String, String>();
            email.put("url", url);
            String text = this.templateEngine.merge("registration-template.vm", email);
            message.setText(text, true);
            message.addInline("logoimg", (Resource)new UrlResource(logoImg));
        };
        this.send(preparator);
    }

    public void sendLaunchFinishNotification(String[] recipients, String url, Launch launch, Project.Configuration settings) {
        String subject = String.format(FINISH_LAUNCH_EMAIL_SUBJECT, launch.getName(), launch.getNumber());
        MimeMessagePreparator preparator = mimeMessage -> {
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject(subject);
            message.setTo(recipients);
            message.setFrom(this.addressFrom);
            HashMap<String, Object> email = new HashMap<String, Object>();
            email.put("name", launch.getName());
            email.put("number", String.valueOf(launch.getNumber()));
            email.put("description", launch.getDescription());
            email.put("url", url);
            email.put("total", launch.getStatistics().getExecutionCounter().getTotal().toString());
            email.put("passed", launch.getStatistics().getExecutionCounter().getPassed().toString());
            email.put("failed", launch.getStatistics().getExecutionCounter().getFailed().toString());
            email.put("skipped", launch.getStatistics().getExecutionCounter().getSkipped().toString());
            email.put("productBugTotal", launch.getStatistics().getIssueCounter().getProductBugTotal().toString());
            email.put("automationBugTotal", launch.getStatistics().getIssueCounter().getAutomationBugTotal().toString());
            email.put("systemIssueTotal", launch.getStatistics().getIssueCounter().getSystemIssueTotal().toString());
            email.put("noDefectTotal", launch.getStatistics().getIssueCounter().getNoDefectTotal().toString());
            email.put("toInvestigateTotal", launch.getStatistics().getIssueCounter().getToInvestigateTotal().toString());
            if (launch.getStatistics().getIssueCounter().getProductBug().entrySet().size() > 1) {
                LinkedHashMap pb = new LinkedHashMap();
                launch.getStatistics().getIssueCounter().getProductBug().forEach((k, v) -> {
                    if (!k.equalsIgnoreCase("total")) {
                        pb.put(settings.getByLocator(k), v.toString());
                    }
                });
                email.put("pbInfo", pb);
            }
            if (launch.getStatistics().getIssueCounter().getAutomationBug().entrySet().size() > 1) {
                LinkedHashMap ab = new LinkedHashMap();
                launch.getStatistics().getIssueCounter().getAutomationBug().forEach((k, v) -> {
                    if (!k.equalsIgnoreCase("total")) {
                        ab.put(settings.getByLocator(k), v.toString());
                    }
                });
                email.put("abInfo", ab);
            }
            if (launch.getStatistics().getIssueCounter().getSystemIssue().entrySet().size() > 1) {
                LinkedHashMap si = new LinkedHashMap();
                launch.getStatistics().getIssueCounter().getSystemIssue().forEach((k, v) -> {
                    if (!k.equalsIgnoreCase("total")) {
                        si.put(settings.getByLocator(k), v.toString());
                    }
                });
                email.put("siInfo", si);
            }
            if (launch.getStatistics().getIssueCounter().getNoDefect().entrySet().size() > 1) {
                LinkedHashMap nd = new LinkedHashMap();
                launch.getStatistics().getIssueCounter().getNoDefect().forEach((k, v) -> {
                    if (!k.equalsIgnoreCase("total")) {
                        nd.put(settings.getByLocator(k), v.toString());
                    }
                });
                email.put("ndInfo", nd);
            }
            if (launch.getStatistics().getIssueCounter().getToInvestigate().entrySet().size() > 1) {
                LinkedHashMap ti = new LinkedHashMap();
                launch.getStatistics().getIssueCounter().getToInvestigate().forEach((k, v) -> {
                    if (!k.equalsIgnoreCase("total")) {
                        ti.put(settings.getByLocator(k), v.toString());
                    }
                });
                email.put("tiInfo", ti);
            }
            String text = this.templateEngine.merge("finish-launch-template.vm", email);
            message.setText(text, true);
            message.addInline("logoimg", (Resource)new UrlResource(this.getClass().getClassLoader().getResource(LOGO)));
        };
        this.send(preparator);
    }

    public void sendRestorePasswordEmail(String subject, String[] recipients, String url, String login) {
        MimeMessagePreparator preparator = mimeMessage -> {
            URL logoImg = this.getClass().getClassLoader().getResource(LOGO);
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject(subject);
            message.setTo(recipients);
            message.setFrom(RP_EMAIL);
            HashMap<String, String> email = new HashMap<String, String>();
            email.put("login", login);
            email.put("url", url);
            String text = this.templateEngine.merge("restore-password-template.vm", email);
            message.setText(text, true);
            message.addInline("logoimg", (Resource)new UrlResource(logoImg));
        };
        this.send(preparator);
    }

    public void setTemplateEngine(TemplateEngine templateEngine) {
        this.templateEngine = templateEngine;
    }

    public void setAddressFrom(String from) {
        this.addressFrom = from;
    }

    public void sendConfirmationEmail(CreateUserRQFull req, String basicUrl) {
        MimeMessagePreparator preparator = mimeMessage -> {
            URL logoImg = this.getClass().getClassLoader().getResource(LOGO);
            MimeMessageHelper message = new MimeMessageHelper(mimeMessage, true, "utf-8");
            message.setSubject("Welcome to Report Portal");
            message.setTo(req.getEmail());
            message.setFrom(RP_EMAIL);
            HashMap<String, String> email = new HashMap<String, String>();
            email.put("url", basicUrl);
            email.put("login", EntityUtils.normalizeUsername((String)req.getLogin()));
            email.put("password", req.getPassword());
            String text = this.templateEngine.merge("create-user-template.vm", email);
            message.setText(text, true);
            message.addInline("logoimg", (Resource)new UrlResource(logoImg));
        };
        this.send(preparator);
    }
}

