/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.util.email;

import com.epam.reportportal.commons.template.TemplateEngine;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.database.dao.ServerSettingsRepository;
import com.epam.ta.reportportal.database.entity.ServerSettings;
import com.epam.ta.reportportal.util.email.EmailService;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.settings.ServerEmailConfig;
import java.io.Serializable;
import java.util.Properties;
import org.jasypt.util.text.BasicTextEncryptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class MailServiceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MailServiceFactory.class);
    private static final int DEFAULT_CONNECTION_TIMEOUT = 5000;
    private static final String DEFAULT_SETTINGS_PROFILE = "default";
    @Autowired
    private TemplateEngine templateEngine;
    @Autowired
    private BasicTextEncryptor encryptor;
    @Autowired
    private ServerSettingsRepository settingsRepository;

    public EmailService getEmailService(ServerEmailConfig config, boolean connectionCheck) {
        boolean authRequired = null != config.getAuthEnabled() && config.getAuthEnabled() != false;
        Properties javaMailProperties = new Properties();
        javaMailProperties.put("mail.smtp.connectiontimeout", (Object)5000);
        javaMailProperties.put("mail.smtp.auth", (Object)authRequired);
        javaMailProperties.put("mail.smtp.starttls.enable", (Object)(authRequired && config.isStarTlsEnabled() ? 1 : 0));
        javaMailProperties.put("mail.debug", (Object)config.isDebug());
        if (config.isSslEnabled()) {
            javaMailProperties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            javaMailProperties.put("mail.smtp.socketFactory.fallback", "false");
        }
        EmailService service = new EmailService(javaMailProperties);
        service.setTemplateEngine(this.templateEngine);
        service.setHost(config.getHost());
        service.setPort(config.getPort());
        service.setProtocol(config.getProtocol());
        if (authRequired) {
            service.setUsername(config.getUsername());
            service.setPassword(this.encryptor.decrypt(config.getPassword()));
        }
        if (connectionCheck) {
            this.checkConnection(service);
        }
        return service;
    }

    public EmailService getDefaultEmailService() {
        EmailService emailService = null;
        ServerSettings serverSettings = (ServerSettings)this.settingsRepository.findOne((Serializable)((Object)DEFAULT_SETTINGS_PROFILE));
        if (null == serverSettings || null == serverSettings.getServerEmailConfig()) {
            BusinessRule.fail().withError(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Email configuration is broken or switched-off. Please config email server in Report Portal settings."});
        } else {
            emailService = this.getEmailService(serverSettings.getServerEmailConfig(), true);
        }
        return emailService;
    }

    private void checkConnection(EmailService service) {
        try {
            service.testConnection();
        }
        catch (Exception e) {
            LOGGER.error("Cannot send email to user", (Throwable)e);
            BusinessRule.fail().withError(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Email configuration is broken or switched-off. Please config email server in Report Portal settings. " + e.getMessage()});
        }
    }
}

