/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.core.dashboard.ICreateDashboardHandler;
import com.epam.ta.reportportal.core.dashboard.IDeleteDashboardHandler;
import com.epam.ta.reportportal.core.dashboard.IGetDashboardHandler;
import com.epam.ta.reportportal.core.dashboard.IUpdateDashboardHandler;
import com.epam.ta.reportportal.ws.controller.IDashboardController;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.SharedEntity;
import com.epam.ta.reportportal.ws.model.dashboard.CreateDashboardRQ;
import com.epam.ta.reportportal.ws.model.dashboard.DashboardResource;
import com.epam.ta.reportportal.ws.model.dashboard.UpdateDashboardRQ;
import io.swagger.annotations.ApiOperation;
import java.security.Principal;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/{projectName}/dashboard"})
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
public class DashboardController
implements IDashboardController {
    @Autowired
    private ICreateDashboardHandler createHandler;
    @Autowired
    private IDeleteDashboardHandler deleteHandler;
    @Autowired
    private IGetDashboardHandler getHandler;
    @Autowired
    private IUpdateDashboardHandler updateHandler;

    @RequestMapping(method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    @ApiOperation(value="Create dashboard for specified project")
    public EntryCreatedRS createDashboard(@PathVariable String projectName, @RequestBody @Validated CreateDashboardRQ createRQ, Principal principal) {
        return this.createHandler.createDashboard(EntityUtils.normalizeProjectName((String)projectName), createRQ, principal.getName());
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiOperation(value="Get all dashboard resources for specified project")
    public Iterable<DashboardResource> getAllDashboards(@PathVariable String projectName, Principal principal) {
        return this.getHandler.getAllDashboards(principal.getName(), EntityUtils.normalizeProjectName((String)projectName));
    }

    @RequestMapping(value={"/{dashboardId}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiOperation(value="Get specified dashboard by ID for specified project")
    public DashboardResource getDashboard(@PathVariable String projectName, @PathVariable String dashboardId, Principal principal) {
        return this.getHandler.getDashboard(dashboardId, principal.getName(), EntityUtils.normalizeProjectName((String)projectName));
    }

    @RequestMapping(value={"/{dashboardId}"}, method={RequestMethod.PUT})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Update specified dashboard for specified project")
    public OperationCompletionRS updateDashboard(@PathVariable String projectName, @PathVariable String dashboardId, @RequestBody @Validated UpdateDashboardRQ updateRQ, Principal principal) {
        return this.updateHandler.updateDashboard(updateRQ, dashboardId, principal.getName(), EntityUtils.normalizeProjectName((String)projectName));
    }

    @RequestMapping(value={"/{dashboardId}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiOperation(value="Delete specified dashboard by ID for specified project")
    public OperationCompletionRS deleteDashboard(@PathVariable String projectName, @PathVariable String dashboardId, Principal principal) {
        return this.deleteHandler.deleteDashboard(dashboardId, principal.getName(), EntityUtils.normalizeProjectName((String)projectName));
    }

    @RequestMapping(value={"/shared"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiOperation(value="Get names of shared dashboards from specified project")
    public Map<String, SharedEntity> getSharedDashboardsNames(@PathVariable String projectName, Principal principal) {
        return this.getHandler.getSharedDashboardsNames(principal.getName(), EntityUtils.normalizeProjectName((String)projectName));
    }
}

