/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.core.favorites.IAddToFavoritesHandler;
import com.epam.ta.reportportal.core.favorites.IRemoveFromFavoritesHandler;
import com.epam.ta.reportportal.ws.controller.IFavoriteResourceController;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.dashboard.DashboardResource;
import com.epam.ta.reportportal.ws.model.favorites.AddFavoriteResourceRQ;
import io.swagger.annotations.ApiOperation;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/{projectName}/favorites"})
public class FavoriteResourceController
implements IFavoriteResourceController {
    @Autowired
    private IAddToFavoritesHandler addToFavoritesHandler;
    @Autowired
    private IRemoveFromFavoritesHandler removeFromFavoritesHandler;

    @RequestMapping(method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiOperation(value="Add resource to favorites")
    public DashboardResource addFavoriteResource(@RequestBody @Validated AddFavoriteResourceRQ addFavoriteResourceRQ, Principal principal, @PathVariable String projectName) {
        return this.addToFavoritesHandler.add(addFavoriteResourceRQ, principal.getName(), EntityUtils.normalizeProjectName((String)projectName));
    }

    @RequestMapping(method={RequestMethod.DELETE})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Remove resource from favorites")
    public OperationCompletionRS removeFromFavorites(Principal principal, @RequestParam(value="resource_id") String resourceId, @RequestParam(value="resource_type") String resourceType) {
        return this.removeFromFavoritesHandler.remove(resourceType, resourceId, principal.getName());
    }
}

