/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.core.user.impl.EditUserHandler;
import com.epam.ta.reportportal.database.BinaryData;
import com.epam.ta.reportportal.database.DataStorage;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.controller.IFileStorageController;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Principal;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
public class FileStorageController
implements IFileStorageController {
    @Autowired
    private DataStorage binaryDataStorage;
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private EditUserHandler editUserHandler;

    @RequestMapping(value={"/{projectName}/data/{dataId}"}, method={RequestMethod.GET})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    public void getFile(@PathVariable String projectName, @PathVariable String dataId, HttpServletResponse response, Principal principal) {
        this.toResponse(response, this.binaryDataStorage.fetchData(dataId));
    }

    @RequestMapping(value={"/data/photo"}, method={RequestMethod.GET})
    @ApiOperation(value="Get photo of current user")
    public void getMyPhoto(Principal principal, HttpServletResponse response) {
        this.toResponse(response, this.userRepository.findUserPhoto(principal.getName()));
    }

    @RequestMapping(value={"/data/userphoto"}, method={RequestMethod.GET})
    @ApiOperation(value="Get user's photo")
    public void getUserPhoto(@RequestParam(value="id") String username, HttpServletResponse response, Principal principal) {
        this.toResponse(response, this.userRepository.findUserPhoto(EntityUtils.normalizeUsername((String)username)));
    }

    @RequestMapping(value={"/data/photo"}, method={RequestMethod.POST})
    @ResponseBody
    @ApiOperation(value="Upload user's photo")
    public OperationCompletionRS uploadPhoto(@RequestParam(value="file") MultipartFile file, Principal principal) {
        return this.editUserHandler.uploadPhoto(principal.getName(), file);
    }

    @RequestMapping(value={"/data/photo"}, method={RequestMethod.DELETE})
    @ResponseBody
    @ApiOperation(value="Delete user's photo")
    public OperationCompletionRS deletePhoto(Principal principal) {
        return this.editUserHandler.deletePhoto(principal.getName());
    }

    private void toResponse(HttpServletResponse response, BinaryData binaryData) {
        if (binaryData != null) {
            response.setContentType(binaryData.getContentType());
            response.setContentLength(binaryData.getLength().intValue());
            try {
                IOUtils.copy((InputStream)binaryData.getInputStream(), (OutputStream)response.getOutputStream());
            }
            catch (IOException e) {
                throw new ReportPortalException("Unable to retrieve binary data from data storage", (Throwable)e);
            }
        } else {
            response.setStatus(HttpStatus.NO_CONTENT.value());
        }
    }
}

