/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.core.jasper.IGetJasperReportHandler;
import com.epam.ta.reportportal.core.jasper.ReportFormat;
import com.epam.ta.reportportal.core.launch.IDeleteLaunchHandler;
import com.epam.ta.reportportal.core.launch.IFinishLaunchHandler;
import com.epam.ta.reportportal.core.launch.IGetLaunchHandler;
import com.epam.ta.reportportal.core.launch.IStartLaunchHandler;
import com.epam.ta.reportportal.core.launch.IUpdateLaunchHandler;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.ws.controller.ILaunchController;
import com.epam.ta.reportportal.ws.model.BulkRQ;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.launch.LaunchResource;
import com.epam.ta.reportportal.ws.model.launch.MergeLaunchesRQ;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.epam.ta.reportportal.ws.model.launch.UpdateLaunchRQ;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JasperPrint;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@Controller
@RequestMapping(value={"/{projectName}/launch"})
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
public class LaunchController
implements ILaunchController {
    @Autowired
    private IStartLaunchHandler createLaunchMessageHandler;
    @Autowired
    private IFinishLaunchHandler finishLaunchMessageHandler;
    @Autowired
    private IDeleteLaunchHandler deleteLaunchMessageHandler;
    @Autowired
    private IGetLaunchHandler getLaunchMessageHandler;
    @Autowired
    private IUpdateLaunchHandler updateLaunchHandler;
    @Autowired
    private IGetJasperReportHandler getJasperHandler;

    @PostMapping
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Starts launch for specified project")
    public EntryCreatedRS startLaunch(@ApiParam(value="Name of project launch starts under", required=true) @PathVariable String projectName, @ApiParam(value="Start launch request body", required=true) @RequestBody @Validated StartLaunchRQ startLaunchRQ, Principal principal) {
        return this.createLaunchMessageHandler.startLaunch(principal.getName(), EntityUtils.normalizeProjectName((String)projectName), startLaunchRQ);
    }

    @RequestMapping(value={"/{launchId}/finish"}, method={RequestMethod.PUT})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Finish launch for specified project")
    public OperationCompletionRS finishLaunch(@PathVariable String projectName, @PathVariable String launchId, @RequestBody @Validated FinishExecutionRQ finishLaunchRQ, Principal principal, HttpServletRequest request) {
        return this.finishLaunchMessageHandler.finishLaunch(launchId, finishLaunchRQ, EntityUtils.normalizeProjectName((String)projectName), principal.getName());
    }

    @PutMapping(value={"/{launchId}/stop"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Force finish launch for specified project")
    public OperationCompletionRS forceFinishLaunch(@PathVariable String projectName, @PathVariable String launchId, @RequestBody @Validated FinishExecutionRQ finishExecutionRQ, Principal principal) {
        return this.finishLaunchMessageHandler.stopLaunch(launchId, finishExecutionRQ, EntityUtils.normalizeProjectName((String)projectName), principal.getName());
    }

    @PutMapping(value={"/stop"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public List<OperationCompletionRS> bulkForceFinish(@PathVariable String projectName, @RequestBody @Validated BulkRQ<FinishExecutionRQ> rq, Principal principal) {
        return this.finishLaunchMessageHandler.stopLaunch(rq, EntityUtils.normalizeProjectName((String)projectName), principal.getName());
    }

    @PutMapping(value={"/{launchId}/update"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @ApiOperation(value="Updates launch for specified project")
    public OperationCompletionRS updateLaunch(@PathVariable String projectName, @PathVariable String launchId, @RequestBody @Validated UpdateLaunchRQ updateLaunchRQ, Principal principal) {
        return this.updateLaunchHandler.updateLaunch(launchId, EntityUtils.normalizeProjectName((String)projectName), principal.getName(), updateLaunchRQ);
    }

    @ResponseBody
    @PutMapping(value={"/update"})
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @ResponseStatus(value=HttpStatus.OK)
    public List<OperationCompletionRS> updateLaunches(@PathVariable String projectName, @RequestBody @Validated BulkRQ<UpdateLaunchRQ> rq, Principal principal) {
        return this.updateLaunchHandler.updateLaunch(rq, EntityUtils.normalizeProjectName((String)projectName), principal.getName());
    }

    @DeleteMapping(value={"/{launchId}"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Delete specified launch by ID")
    public OperationCompletionRS deleteLaunch(@PathVariable String projectName, @PathVariable String launchId, Principal principal) {
        return this.deleteLaunchMessageHandler.deleteLaunch(launchId, EntityUtils.normalizeProjectName((String)projectName), principal.getName());
    }

    @GetMapping(value={"/{launchId}"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get specified launch")
    public LaunchResource getLaunch(@PathVariable String projectName, @PathVariable String launchId, Principal principal) {
        return this.getLaunchMessageHandler.getLaunch(launchId, principal.getName(), EntityUtils.normalizeProjectName((String)projectName));
    }

    @GetMapping
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get list of project launches by filter")
    public Iterable<LaunchResource> getProjectLaunches(@PathVariable String projectName, @FilterFor(value=Launch.class) Filter filter, @SortFor(value=Launch.class) Pageable pageable, Principal principal) {
        return this.getLaunchMessageHandler.getProjectLaunches(EntityUtils.normalizeProjectName((String)projectName), filter, pageable, principal.getName());
    }

    @RequestMapping(value={"/mode"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectMemberPermission')")
    @ApiOperation(value="Get launches of specified project from DEBUG mode")
    public Iterable<LaunchResource> getDebugLaunches(@PathVariable String projectName, @FilterFor(value=Launch.class) Filter filter, @SortFor(value=Launch.class) Pageable pageable, Principal principal) {
        return this.getLaunchMessageHandler.getDebugLaunches(EntityUtils.normalizeProjectName((String)projectName), principal.getName(), filter, pageable);
    }

    @RequestMapping(value={"/tags"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get all unique tags of project launches")
    public List<String> getAllTags(@PathVariable String projectName, @RequestParam(value="filter.cnt.tags") String value, Principal principal) {
        return this.getLaunchMessageHandler.getTags(EntityUtils.normalizeProjectName((String)projectName), value);
    }

    @RequestMapping(value={"/owners"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get all unique owners of project launches")
    public List<String> getAllOwners(@PathVariable String projectName, @RequestParam(value="filter.cnt.user") String value, @RequestParam(value="mode", required=false, defaultValue="DEFAULT") String mode, Principal principal) {
        return this.getLaunchMessageHandler.getOwners(EntityUtils.normalizeProjectName((String)projectName), value, "userRef", mode);
    }

    @RequestMapping(value={"/names"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Get launch names of project")
    public List<String> getAllLaunchNames(@PathVariable String projectName, @RequestParam(value="filter.cnt.name") String value, Principal principal) {
        return this.getLaunchMessageHandler.getLaunchNames(EntityUtils.normalizeProjectName((String)projectName), value);
    }

    @RequestMapping(value={"/compare"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Compare launches")
    public Map<String, List<ChartObject>> compareLaunches(@PathVariable String projectName, @RequestParam(value="ids") String[] ids, Principal principal) {
        return this.getLaunchMessageHandler.getLaunchesComparisonInfo(EntityUtils.normalizeProjectName((String)projectName), ids);
    }

    @PostMapping(value={"/merge"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Merge set of specified launches in common one")
    public LaunchResource mergeLaunches(@ApiParam(value="Name of project contains merging launches under", required=true) @PathVariable String projectName, @ApiParam(value="Merge launches request body", required=true) @RequestBody @Validated MergeLaunchesRQ mergeLaunchesRQ, Principal principal) {
        return this.updateLaunchHandler.mergeLaunches(EntityUtils.normalizeProjectName((String)projectName), principal.getName(), mergeLaunchesRQ);
    }

    @RequestMapping(value={"/{launchId}/analyze/{strategy}"}, method={RequestMethod.POST})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Start launch auto-analyzer on demand")
    public OperationCompletionRS startLaunchAnalyzer(@PathVariable String projectName, @PathVariable String launchId, @PathVariable String strategy, Principal principal) throws InterruptedException, ExecutionException {
        return this.updateLaunchHandler.startLaunchAnalyzer(EntityUtils.normalizeProjectName((String)projectName), launchId, strategy);
    }

    @RequestMapping(value={"/status"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiIgnore
    public Map<String, String> getStatuses(@PathVariable String projectName, @RequestParam(value="ids") String[] ids, Principal principal) {
        return this.getLaunchMessageHandler.getStatuses(EntityUtils.normalizeProjectName((String)projectName), ids);
    }

    @RequestMapping(value={"/{launchId}/report"}, method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @ApiOperation(value="Export specified launch", notes="Only following formats are supported: pdf (by default), xml, xls, html.")
    public void getLaunchReport(@PathVariable String projectName, @PathVariable String launchId, @RequestParam(value="view", required=false, defaultValue="pdf") String view, Principal principal, HttpServletResponse response) throws IOException {
        JasperPrint jasperPrint = this.getJasperHandler.getLaunchDetails(launchId, principal.getName());
        ReportFormat format = this.getJasperHandler.getReportFormat(view);
        response.setContentType(format.getContentType());
        response.setHeader("Content-Disposition", String.format("attachment; filename=RP_%s_Report.%s", format.name(), format.getValue()));
        this.getJasperHandler.writeReport(format, (OutputStream)response.getOutputStream(), jasperPrint);
    }

    @DeleteMapping
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    public List<OperationCompletionRS> deleteLaunches(@PathVariable String projectName, @RequestParam(value="ids") String[] ids, Principal principal) {
        return this.deleteLaunchMessageHandler.deleteLaunches(ids, projectName, principal.getName());
    }
}

