/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller.impl;

import com.epam.reportportal.commons.ContentTypeResolver;
import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.log.ICreateLogHandler;
import com.epam.ta.reportportal.core.log.IDeleteLogHandler;
import com.epam.ta.reportportal.core.log.IGetLogHandler;
import com.epam.ta.reportportal.database.BinaryData;
import com.epam.ta.reportportal.database.entity.Log;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.controller.ILogController;
import com.epam.ta.reportportal.ws.model.BatchElementCreatedRS;
import com.epam.ta.reportportal.ws.model.BatchSaveOperatingRS;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.log.LogResource;
import com.epam.ta.reportportal.ws.model.log.SaveLogRQ;
import com.epam.ta.reportportal.ws.resolver.FilterFor;
import com.epam.ta.reportportal.ws.resolver.SortFor;
import io.swagger.annotations.ApiOperation;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolation;
import javax.validation.Path;
import javax.validation.Validator;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import springfox.documentation.annotations.ApiIgnore;

@Controller
@RequestMapping(value={"/{projectName}/log"})
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
public class LogController
implements ILogController {
    @Autowired
    private ICreateLogHandler createLogMessageHandler;
    @Autowired
    private IDeleteLogHandler deleteLogMessageHandler;
    @Autowired
    private IGetLogHandler getLogHandler;
    @Autowired
    private ContentTypeResolver contentTypeResolver;
    @Autowired
    private Validator validator;

    @RequestMapping(method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiOperation(value="Create log")
    public EntryCreatedRS createLog(@PathVariable String projectName, @RequestBody SaveLogRQ createLogRQ, Principal principal) {
        this.validateSaveRQ(createLogRQ);
        return this.createLogMessageHandler.createLog(createLogRQ, null, null, EntityUtils.normalizeProjectName((String)projectName));
    }

    @RequestMapping(method={RequestMethod.POST}, consumes={"multipart/form-data"})
    @ResponseBody
    @ApiIgnore
    public ResponseEntity<BatchSaveOperatingRS> createLog(@PathVariable String projectName, @RequestPart(value="json_request_part") SaveLogRQ[] createLogRQs, HttpServletRequest request, Principal principal) {
        String prjName = EntityUtils.normalizeProjectName((String)projectName);
        Map uploadedFiles = this.getUploadedFiles(request);
        BatchSaveOperatingRS response = new BatchSaveOperatingRS();
        try {
            for (SaveLogRQ createLogRq : createLogRQs) {
                try {
                    EntryCreatedRS responseItem;
                    String filename;
                    this.validateSaveRQ(createLogRq);
                    String string = filename = createLogRq.getFile() == null ? null : createLogRq.getFile().getName();
                    if (StringUtils.isEmpty((CharSequence)filename)) {
                        responseItem = this.createLog(prjName, createLogRq, principal);
                    } else {
                        MultipartFile data = this.findByFileName(filename, uploadedFiles);
                        BusinessRule.expect((Object)data, (Predicate)Predicates.notNull()).verify(ErrorType.BINARY_DATA_CANNOT_BE_SAVED, new Object[]{Suppliers.formattedSupplier((String)"There is no request part or file with name {}", (Object[])new Object[]{filename})});
                        if (!StringUtils.isEmpty((CharSequence)data.getContentType()) && !"application/octet-stream".equals(data.getContentType())) {
                            responseItem = this.createLogMessageHandler.createLog(createLogRq, new BinaryData(data.getContentType(), Long.valueOf(data.getSize()), data.getInputStream()), data.getOriginalFilename(), prjName);
                        } else {
                            byte[] consumedData = IOUtils.toByteArray((InputStream)data.getInputStream());
                            responseItem = this.createLogMessageHandler.createLog(createLogRq, new BinaryData(this.contentTypeResolver.detectContentType(consumedData), Long.valueOf(data.getSize()), (InputStream)new ByteArrayInputStream(consumedData)), data.getOriginalFilename(), prjName);
                        }
                    }
                    response.addResponse(new BatchElementCreatedRS(responseItem.getId()));
                }
                catch (ReportPortalException e) {
                    response.addResponse(new BatchElementCreatedRS(ExceptionUtils.getStackTrace((Throwable)e), ExceptionUtils.getMessage((Throwable)e)));
                }
            }
        }
        catch (IOException e) {
            throw new ReportPortalException("Unable to save binary data", (Throwable)e);
        }
        return new ResponseEntity((Object)response, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/{logId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    @ApiOperation(value="Delete log")
    public OperationCompletionRS deleteLog(@PathVariable String projectName, @PathVariable String logId, Principal principal) {
        return this.deleteLogMessageHandler.deleteLog(logId, EntityUtils.normalizeProjectName((String)projectName), principal.getName());
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="Get logs by filter")
    public Iterable<LogResource> getLogs(@PathVariable String projectName, @RequestParam(value="filter.eq.item", required=true) String testStepId, @FilterFor(value=Log.class) Filter filter, @SortFor(value=Log.class) Pageable pageble, Principal principal) {
        return this.getLogHandler.getLogs(testStepId, EntityUtils.normalizeProjectName((String)projectName), filter, pageble);
    }

    @RequestMapping(value={"/{logId}"}, method={RequestMethod.GET})
    @ResponseBody
    @ApiOperation(value="Get log")
    public LogResource getLog(@PathVariable String projectName, @PathVariable String logId, Principal principal) {
        return this.getLogHandler.getLog(logId, EntityUtils.normalizeProjectName((String)projectName));
    }

    private MultipartFile findByFileName(String filename, Map<String, MultipartFile> files) {
        if (files.containsKey(filename)) {
            return files.get(filename);
        }
        for (MultipartFile file : files.values()) {
            if (!filename.equals(file.getOriginalFilename())) continue;
            return file;
        }
        return null;
    }

    private void validateSaveRQ(SaveLogRQ saveLogRQ) {
        Set constraintViolations = this.validator.validate((Object)saveLogRQ, new Class[0]);
        if (constraintViolations != null && !constraintViolations.isEmpty()) {
            StringBuilder messageBuilder = new StringBuilder();
            for (ConstraintViolation constraintViolation : constraintViolations) {
                messageBuilder.append("[");
                messageBuilder.append("Incorrect value in save log request '");
                messageBuilder.append(constraintViolation.getInvalidValue());
                messageBuilder.append("' in field '");
                Iterator iterator = constraintViolation.getPropertyPath().iterator();
                messageBuilder.append(iterator.hasNext() ? ((Path.Node)iterator.next()).getName() : "");
                messageBuilder.append("'.]");
            }
            throw new ReportPortalException(ErrorType.INCORRECT_REQUEST, new Object[]{messageBuilder.toString()});
        }
    }

    private Map<String, MultipartFile> getUploadedFiles(HttpServletRequest request) {
        HashMap<String, MultipartFile> uploadedFiles = new HashMap<String, MultipartFile>();
        if (request instanceof MultipartHttpServletRequest) {
            MultiValueMap multiFileMap = ((MultipartHttpServletRequest)request).getMultiFileMap();
            for (List multipartFiles : multiFileMap.values()) {
                for (MultipartFile file : multipartFiles) {
                    uploadedFiles.put(file.getOriginalFilename(), file);
                }
            }
        }
        return uploadedFiles;
    }
}

