/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.core.project.settings.impl.CreateProjectSettingsHandler;
import com.epam.ta.reportportal.core.project.settings.impl.DeleteProjectSettingsHandler;
import com.epam.ta.reportportal.core.project.settings.impl.GetProjectSettingsHandler;
import com.epam.ta.reportportal.core.project.settings.impl.UpdateProjectSettingsHandler;
import com.epam.ta.reportportal.ws.controller.IProjectSettingsController;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.project.config.CreateIssueSubTypeRQ;
import com.epam.ta.reportportal.ws.model.project.config.ProjectSettingsResource;
import com.epam.ta.reportportal.ws.model.project.config.UpdateIssueSubTypeRQ;
import io.swagger.annotations.ApiOperation;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@Controller
@RequestMapping(value={"/{projectName}/settings"})
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
public class ProjectSettingsController
implements IProjectSettingsController {
    @Autowired
    private CreateProjectSettingsHandler createSettings;
    @Autowired
    private UpdateProjectSettingsHandler updateSettings;
    @Autowired
    private DeleteProjectSettingsHandler deleteSettings;
    @Autowired
    private GetProjectSettingsHandler getSettings;

    @RequestMapping(value={"/sub-type"}, method={RequestMethod.POST})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectLeadPermission')")
    @ApiOperation(value="Creation of custom project specific issue sub-type")
    public EntryCreatedRS createProjectIssueSubType(@PathVariable String projectName, @RequestBody @Validated CreateIssueSubTypeRQ request, Principal principal) {
        return this.createSettings.createProjectIssueSubType(EntityUtils.normalizeProjectName((String)projectName), principal.getName(), request);
    }

    @RequestMapping(value={"/sub-type"}, method={RequestMethod.PUT})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectLeadPermission')")
    @ApiOperation(value="Update of custom project specific issue sub-type")
    public OperationCompletionRS updateProjectIssueSubType(@PathVariable String projectName, @RequestBody @Validated UpdateIssueSubTypeRQ request, Principal principal) {
        return this.updateSettings.updateProjectIssueSubType(EntityUtils.normalizeProjectName((String)projectName), principal.getName(), request);
    }

    @RequestMapping(value={"/sub-type/{id}"}, method={RequestMethod.DELETE})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'projectLeadPermission')")
    @ApiOperation(value="Delete custom project specific issue sub-type")
    public OperationCompletionRS deleteProjectIssueSubType(@PathVariable String projectName, @PathVariable String id, Principal principal) {
        return this.deleteSettings.deleteProjectIssueSubType(EntityUtils.normalizeProjectName((String)projectName), principal.getName(), id);
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.OK)
    @PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
    @ApiOperation(value="Get project specific issue sub-types")
    public ProjectSettingsResource getProjectSettings(@PathVariable String projectName, Principal principal) {
        return this.getSettings.getProjectSettings(EntityUtils.normalizeProjectName((String)projectName));
    }
}

