/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.controller.impl;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.core.widget.ICreateWidgetHandler;
import com.epam.ta.reportportal.core.widget.IGetWidgetHandler;
import com.epam.ta.reportportal.core.widget.IUpdateWidgetHandler;
import com.epam.ta.reportportal.ws.controller.IWidgetController;
import com.epam.ta.reportportal.ws.model.EntryCreatedRS;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.SharedEntity;
import com.epam.ta.reportportal.ws.model.widget.WidgetRQ;
import com.epam.ta.reportportal.ws.model.widget.WidgetResource;
import com.epam.ta.reportportal.ws.validation.WidgetRQCustomValidator;
import io.swagger.annotations.ApiOperation;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@Controller
@RequestMapping(value={"/{projectName}/widget"})
@PreAuthorize(value="hasPermission(#projectName.toLowerCase(), 'isAssignedToProject')")
public class WidgetController
implements IWidgetController {
    @Autowired
    private IGetWidgetHandler getHandler;
    @Autowired
    private ICreateWidgetHandler createHandler;
    @Autowired
    private IUpdateWidgetHandler updateHandler;
    @Autowired
    private WidgetRQCustomValidator validator;

    @InitBinder
    @PreAuthorize(value="permitAll")
    protected void initBinder(WebDataBinder binder) {
        binder.setValidator((Validator)this.validator);
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ResponseBody
    @ApiOperation(value="Create new widget")
    public EntryCreatedRS createWidget(@PathVariable String projectName, @RequestBody @Validated(value={WidgetRQCustomValidator.class}) WidgetRQ createWidgetRQ, Principal principal) {
        return this.createHandler.createWidget(createWidgetRQ, EntityUtils.normalizeProjectName((String)projectName), principal.getName());
    }

    @RequestMapping(value={"/{widgetId}"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiOperation(value="Get widget by ID")
    public WidgetResource getWidget(@PathVariable String projectName, @PathVariable String widgetId, Principal principal) {
        return this.getHandler.getWidget(widgetId, principal.getName(), EntityUtils.normalizeProjectName((String)projectName));
    }

    @RequestMapping(value={"/{widgetId}"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiOperation(value="Update specified widget")
    public OperationCompletionRS updateWidget(@PathVariable String projectName, @PathVariable String widgetId, @RequestBody @Validated WidgetRQ updateRQ, Principal principal) {
        return this.updateHandler.updateWidget(widgetId, updateRQ, principal.getName(), EntityUtils.normalizeProjectName((String)projectName));
    }

    @RequestMapping(value={"/names/shared"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @Deprecated
    @ApiIgnore
    public Map<String, SharedEntity> getSharedWidgets(Principal principal, @PathVariable String projectName) {
        return this.getHandler.getSharedWidgetNames(principal.getName(), EntityUtils.normalizeProjectName((String)projectName));
    }

    @RequestMapping(value={"/shared"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiOperation(value="Load shared widgets")
    public List<WidgetResource> getSharedWidgetsList(Principal principal, @PathVariable String projectName) {
        return this.getHandler.getSharedWidgetsList(principal.getName(), EntityUtils.normalizeProjectName((String)projectName));
    }

    @RequestMapping(value={"/names/all"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    @ApiOperation(value="Load all widget names which belong to a user")
    public List<String> getWidgetNames(@PathVariable String projectName, Principal principal) {
        return this.getHandler.getWidgetNames(EntityUtils.normalizeProjectName((String)projectName), principal.getName());
    }
}

