/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter;

import com.epam.ta.reportportal.database.entity.Dashboard;
import com.epam.ta.reportportal.util.LazyReference;
import com.epam.ta.reportportal.ws.controller.impl.DashboardController;
import com.epam.ta.reportportal.ws.controller.impl.WidgetController;
import com.epam.ta.reportportal.ws.converter.builders.DashboardResourceBuilder;
import com.epam.ta.reportportal.ws.model.dashboard.DashboardResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.hateoas.Identifiable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Service;

@Service
public class DashboardResourceAssembler
extends ResourceAssemblerSupport<Dashboard, DashboardResource> {
    public static final String REL = "related";
    @Autowired
    @Qualifier(value="dashboardResourceBuilder.reference")
    private LazyReference<DashboardResourceBuilder> builderLazyReference;

    public DashboardResourceAssembler() {
        super(DashboardController.class, DashboardResource.class);
    }

    public DashboardResource toResource(Dashboard entity) {
        Link selfLink = ((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(DashboardController.class, (Object[])new Object[]{entity.getProjectName()}).slash((Identifiable)entity)).withSelfRel();
        DashboardResourceBuilder resourceBuilder = (DashboardResourceBuilder)this.builderLazyReference.get();
        resourceBuilder.addDashboard(entity).addLink(selfLink);
        for (Dashboard.WidgetObject widget : entity.getWidgets()) {
            Link widgetLink = ((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(WidgetController.class, (Object[])new Object[]{entity.getProjectName()}).slash((Object)widget.getWidgetId())).withRel(REL);
            resourceBuilder.addLink(widgetLink);
        }
        return (DashboardResource)resourceBuilder.build();
    }
}

