/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter;

import java.util.Collection;
import org.springframework.data.domain.Page;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceSupport;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.util.Assert;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public abstract class PagedResourcesAssember<T, R extends ResourceSupport>
extends ResourceAssemblerSupport<T, R> {
    private static final String PAGE_PARAMETER = "page.page";
    private static final String SIZE_PARAMETER = "page.size";

    public PagedResourcesAssember(Class<?> controllerClass, Class<R> resourceType) {
        super(controllerClass, resourceType);
    }

    public PagedResources<R> toPagedResources(Page<T> content) {
        Assert.notNull(content);
        PagedResources pagedResources = new PagedResources((Collection)this.toResources(content), new PagedResources.PageMetadata((long)content.getSize(), (long)(content.getNumber() + 1), content.getTotalElements(), (long)content.getTotalPages()), new Link[0]);
        this.addPagingLinks(pagedResources, content);
        return pagedResources;
    }

    protected void addPagingLinks(PagedResources<R> pageResource, Page<T> page) {
        this.addSelfLink(pageResource);
        this.addFirstLink(pageResource, page, PAGE_PARAMETER, SIZE_PARAMETER);
        this.addPreviousLink(pageResource, page, PAGE_PARAMETER, SIZE_PARAMETER);
        this.addNextLink(pageResource, page, PAGE_PARAMETER, SIZE_PARAMETER);
        this.addLastLink(pageResource, page, PAGE_PARAMETER, SIZE_PARAMETER);
    }

    private void addSelfLink(PagedResources<R> paged) {
        paged.add(new Link(this.createBuilder().build().toUriString(), "self"));
    }

    private void addPreviousLink(PagedResources<R> paged, Page<T> page, String pageParam, String sizeParam) {
        if (page.hasPrevious()) {
            paged.add(this.buildPageLink(pageParam, page.getNumber(), sizeParam, page.getSize(), "prev"));
        }
    }

    private void addNextLink(PagedResources<R> paged, Page<T> page, String pageParam, String sizeParam) {
        if (page.hasNext()) {
            paged.add(this.buildPageLink(pageParam, page.getNumber() + 2, sizeParam, page.getSize(), "next"));
        }
    }

    private void addFirstLink(PagedResources<R> paged, Page<T> page, String pageParam, String sizeParam) {
        if (!page.isFirst()) {
            paged.add(this.buildPageLink(pageParam, 1, sizeParam, page.getSize(), "first"));
        }
    }

    private void addLastLink(PagedResources<R> paged, Page<T> page, String pageParam, String sizeParam) {
        if (!page.isLast()) {
            paged.add(this.buildPageLink(pageParam, page.getTotalPages(), sizeParam, page.getSize(), "last"));
        }
    }

    private Link buildPageLink(String pageParam, int page, String sizeParam, int size, String rel) {
        String path = this.createBuilder().replaceQueryParam(pageParam, new Object[]{page}).replaceQueryParam(sizeParam, new Object[]{size}).build().toUriString();
        return new Link(path, rel);
    }

    private ServletUriComponentsBuilder createBuilder() {
        return ServletUriComponentsBuilder.fromCurrentRequest();
    }
}

