/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter;

import com.epam.ta.reportportal.database.entity.ExternalSystem;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.util.LazyReference;
import com.epam.ta.reportportal.ws.controller.impl.ExternalSystemController;
import com.epam.ta.reportportal.ws.controller.impl.ProjectController;
import com.epam.ta.reportportal.ws.converter.PagedResourcesAssember;
import com.epam.ta.reportportal.ws.converter.builders.ProjectResourceBuilder;
import com.epam.ta.reportportal.ws.model.project.ProjectResource;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.hateoas.Identifiable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Service;

@Service
public class ProjectResourceAssembler
extends PagedResourcesAssember<Project, ProjectResource> {
    public static final String REL = "related";
    @Autowired
    @Qualifier(value="projectResourceBuilder.reference")
    private LazyReference<ProjectResourceBuilder> builder;

    public ProjectResourceAssembler() {
        super(ProjectController.class, ProjectResource.class);
    }

    public ProjectResource toResource(Project project, Iterable<ExternalSystem> systems) {
        Link selfLink = ((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(ProjectController.class).slash((Identifiable)project)).withSelfRel();
        ProjectResourceBuilder resourceBuilder = (ProjectResourceBuilder)this.builder.get();
        resourceBuilder.addProject(project, systems).addLink(selfLink);
        for (String systemId : project.getConfiguration().getExternalSystem()) {
            Link sysLink = ((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(ExternalSystemController.class, (Object[])new Object[]{project.getId()}).slash((Object)systemId)).withRel(REL);
            resourceBuilder.addLink(sysLink);
        }
        return (ProjectResource)resourceBuilder.build();
    }

    public ProjectResource toResource(Project entity) {
        Link selfLink = ((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(ProjectController.class).slash((Identifiable)entity)).withSelfRel();
        ProjectResourceBuilder resourceBuilder = (ProjectResourceBuilder)this.builder.get();
        resourceBuilder.addProject(entity, new ArrayList()).addLink(selfLink);
        for (String systemId : entity.getConfiguration().getExternalSystem()) {
            Link widgetLink = ((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(ExternalSystemController.class, (Object[])new Object[]{entity.getId()}).slash((Object)systemId)).withRel(REL);
            resourceBuilder.addLink(widgetLink);
        }
        return (ProjectResource)resourceBuilder.build();
    }
}

