/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter;

import com.epam.ta.reportportal.database.entity.ServerSettings;
import com.epam.ta.reportportal.util.LazyReference;
import com.epam.ta.reportportal.ws.controller.impl.SettingsController;
import com.epam.ta.reportportal.ws.converter.builders.ServerSettingsResourceBuilder;
import com.epam.ta.reportportal.ws.model.settings.ServerSettingsResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.hateoas.Identifiable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Service;

@Service
public class ServerSettingsResourceAssembler
extends ResourceAssemblerSupport<ServerSettings, ServerSettingsResource> {
    @Autowired
    @Qualifier(value="serverSettingsResourceBuilder.reference")
    private LazyReference<ServerSettingsResourceBuilder> builder;

    public ServerSettingsResourceAssembler() {
        super(SettingsController.class, ServerSettingsResource.class);
    }

    public ServerSettingsResource toResource(ServerSettings settings) {
        Link selfLink = ((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(SettingsController.class).slash((Identifiable)settings)).withSelfRel();
        ServerSettingsResourceBuilder resourceBuilder = (ServerSettingsResourceBuilder)this.builder.get();
        resourceBuilder.addServerSettings(settings).addLink(selfLink);
        return (ServerSettingsResource)resourceBuilder.build();
    }
}

