/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter;

import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.dao.TestItemRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.ws.controller.ITestItemController;
import com.epam.ta.reportportal.ws.controller.impl.TestItemController;
import com.epam.ta.reportportal.ws.converter.ProjectRelatedResourceAssembler;
import com.epam.ta.reportportal.ws.converter.builders.TestItemResourceBuilder;
import com.epam.ta.reportportal.ws.model.TestItemResource;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.hateoas.Identifiable;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.stereotype.Service;

@Service
public class TestItemResourceAssembler
extends ProjectRelatedResourceAssembler<TestItem, TestItemResource> {
    @Autowired
    private TestItemRepository testItemRepository;
    @Autowired
    private LaunchRepository launchRepository;

    public TestItemResourceAssembler() {
        super(ITestItemController.class, TestItemResource.class);
    }

    public PagedResources<TestItemResource> toPagedResources(Page<TestItem> content, String project) {
        PagedResources resources = super.toPagedResources(content, project);
        Map allPathsNames = this.getPagePathNames(content);
        this.setPathElementsNames(resources, allPathsNames);
        return resources;
    }

    public TestItemResource toResource(TestItem item) {
        TestItemResource testItemResource = this.toResource(item, null);
        testItemResource.setPathNames(this.getItemName(item.getPath()));
        return testItemResource;
    }

    public TestItemResource toResource(TestItem item, String projectName) {
        LinkedHashMap<String, Object> pathNamesInitValue = new LinkedHashMap<String, Object>();
        for (String pathElement : item.getPath()) {
            pathNamesInitValue.put(pathElement, null);
        }
        return (TestItemResource)new TestItemResourceBuilder().addTestItem(item, null).addPathNames(pathNamesInitValue).addLink(((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(TestItemController.class, (Object[])new Object[]{projectName == null ? ((Launch)this.launchRepository.findOne((Serializable)((Object)item.getLaunchRef()))).getProjectRef() : projectName}).slash((Identifiable)item)).withSelfRel()).build();
    }

    private Map<String, String> getPagePathNames(Iterable<TestItem> content) {
        HashSet allPathsIds = new HashSet();
        for (TestItem testItem : content) {
            allPathsIds.addAll(testItem.getPath());
        }
        ArrayList allIds = new ArrayList();
        allIds.addAll(allPathsIds);
        return this.getItemName(allIds);
    }

    private void setPathElementsNames(PagedResources<TestItemResource> resources, Map<String, String> allPathsNames) {
        for (TestItemResource testItemResource : resources) {
            Set pathIds = testItemResource.getPathNames().keySet();
            for (String pathId : pathIds) {
                testItemResource.getPathNames().put(pathId, allPathsNames.get(pathId));
            }
        }
    }

    private Map<String, String> getItemName(List<String> ids) {
        Map result = this.testItemRepository.findPathNames(ids);
        LinkedHashMap<String, String> orderedResult = new LinkedHashMap<String, String>();
        for (String id : ids) {
            orderedResult.put(id, (String)result.get(id));
        }
        return orderedResult;
    }
}

