/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter;

import com.epam.ta.reportportal.database.entity.widget.Widget;
import com.epam.ta.reportportal.util.LazyReference;
import com.epam.ta.reportportal.ws.controller.impl.UserFilterController;
import com.epam.ta.reportportal.ws.controller.impl.WidgetController;
import com.epam.ta.reportportal.ws.converter.builders.WidgetResourceBuilder;
import com.epam.ta.reportportal.ws.model.widget.WidgetResource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.hateoas.Identifiable;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Service;

@Service
public class WidgetResourceAssembler
extends ResourceAssemblerSupport<Widget, WidgetResource> {
    public static final String REL = "related";
    @Autowired
    @Qualifier(value="widgetResourceBuilder.reference")
    private LazyReference<WidgetResourceBuilder> builderLazyReference;

    public WidgetResourceAssembler() {
        super(WidgetController.class, WidgetResource.class);
    }

    public WidgetResource toResource(Widget widget) {
        Link selfLink = ((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(WidgetController.class, (Object[])new Object[]{widget.getProjectName()}).slash((Identifiable)widget)).withSelfRel();
        WidgetResourceBuilder widgetResourceBuilder = (WidgetResourceBuilder)this.builderLazyReference.get();
        widgetResourceBuilder.addWidget(widget).addLink(selfLink);
        if (widget.getApplyingFilterId() != null) {
            Link filterLink = ((ControllerLinkBuilder)ControllerLinkBuilder.linkTo(UserFilterController.class, (Object[])new Object[]{widget.getProjectName()}).slash((Object)widget.getApplyingFilterId())).withRel(REL);
            widgetResourceBuilder.addLink(filterLink);
        }
        return (WidgetResource)widgetResourceBuilder.build();
    }
}

