/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.database.entity.Dashboard;
import com.epam.ta.reportportal.ws.converter.builders.ResourceBuilder;
import com.epam.ta.reportportal.ws.model.dashboard.DashboardResource;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class DashboardResourceBuilder
extends ResourceBuilder<DashboardResource> {
    public DashboardResourceBuilder addDashboard(Dashboard dashboard) {
        if (dashboard != null) {
            ((DashboardResource)this.getObject()).setDashboardId(dashboard.getId());
            ((DashboardResource)this.getObject()).setName(dashboard.getName());
            if (null != dashboard.getWidgets()) {
                List models = dashboard.getWidgets().stream().map(widgetObject -> new DashboardResource.WidgetObjectModel(widgetObject.getWidgetId(), widgetObject.getWidgetSize(), widgetObject.getWidgetPosition())).collect(Collectors.toList());
                ((DashboardResource)this.getObject()).setWidgets(models);
            }
            if (null != dashboard.getAcl()) {
                ((DashboardResource)this.getObject()).setOwner(dashboard.getAcl().getOwnerUserId());
                ((DashboardResource)this.getObject()).setIsShared(!dashboard.getAcl().getEntries().isEmpty());
            }
        }
        return this;
    }

    protected DashboardResource initObject() {
        return new DashboardResource();
    }
}

