/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.commons.EntityUtils;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.ws.converter.builders.Builder;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import com.google.common.collect.Sets;
import java.util.Date;
import java.util.Set;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class LaunchBuilder
extends Builder<Launch> {
    public LaunchBuilder addStartRQ(StartLaunchRQ request) {
        if (request != null) {
            Set tags;
            ((Launch)this.getObject()).setStartTime(request.getStartTime());
            ((Launch)this.getObject()).setName(request.getName().trim());
            if (null != request.getDescription()) {
                ((Launch)this.getObject()).setDescription(request.getDescription().trim());
            }
            if (null != (tags = request.getTags())) {
                tags = Sets.newHashSet((Iterable)EntityUtils.trimStrings((Iterable)EntityUtils.update((Iterable)tags)));
            }
            ((Launch)this.getObject()).setTags(tags);
            if (request.getMode() != null) {
                ((Launch)this.getObject()).setMode(request.getMode());
            }
        }
        return this;
    }

    public LaunchBuilder addStatus(Status status) {
        ((Launch)this.getObject()).setStatus(status);
        return this;
    }

    public LaunchBuilder addUser(String userName) {
        ((Launch)this.getObject()).setUserRef(userName);
        return this;
    }

    public LaunchBuilder addProject(String projectName) {
        ((Launch)this.getObject()).setProjectRef(projectName);
        return this;
    }

    public LaunchBuilder addEndTime(Date endTime) {
        ((Launch)this.getObject()).setEndTime(endTime);
        return this;
    }

    protected Launch initObject() {
        return new Launch();
    }
}

