/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.database.entity.statistics.IssueCounter;
import com.epam.ta.reportportal.database.entity.statistics.Statistics;
import com.epam.ta.reportportal.util.analyzer.IssuesAnalyzerService;
import com.epam.ta.reportportal.ws.converter.builders.ResourceBuilder;
import com.epam.ta.reportportal.ws.model.launch.LaunchResource;
import com.epam.ta.reportportal.ws.model.statistics.ExecutionCounter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class LaunchResourceBuilder
extends ResourceBuilder<LaunchResource> {
    private static final Logger LOGGER = LoggerFactory.getLogger(LaunchResourceBuilder.class);
    @Autowired
    private IssuesAnalyzerService analyzeService;

    public LaunchResourceBuilder addLaunch(Launch launch) {
        if (launch != null) {
            LaunchResource resource = (LaunchResource)this.getObject();
            resource.setLaunchId(launch.getId());
            resource.setName(launch.getName());
            resource.setNumber(launch.getNumber());
            resource.setDescription(launch.getDescription());
            resource.setStatus(launch.getStatus() == null ? null : launch.getStatus().toString());
            resource.setStartTime(launch.getStartTime());
            resource.setEndTime(launch.getEndTime());
            resource.setTags(launch.getTags());
            resource.setMode(launch.getMode());
            resource.setApproximateDuration(launch.getApproximateDuration());
            try {
                if (null != this.analyzeService.getProcessIds().get((Object)launch.getId())) {
                    if ("started".equalsIgnoreCase((String)this.analyzeService.getProcessIds().get((Object)launch.getId()))) {
                        resource.setIsProcessing(true);
                    }
                } else {
                    resource.setIsProcessing(false);
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                resource.setIsProcessing(false);
            }
            resource.setOwner(launch.getUserRef());
            Statistics statistics = launch.getStatistics();
            if (statistics != null) {
                IssueCounter issueCounter;
                com.epam.ta.reportportal.ws.model.statistics.Statistics statisticsCounters = new com.epam.ta.reportportal.ws.model.statistics.Statistics();
                com.epam.ta.reportportal.database.entity.statistics.ExecutionCounter executionCounter = statistics.getExecutionCounter();
                if (executionCounter != null) {
                    ExecutionCounter execution = new ExecutionCounter();
                    execution.setTotal(executionCounter.getTotal().toString());
                    execution.setPassed(executionCounter.getPassed().toString());
                    execution.setFailed(executionCounter.getFailed().toString());
                    execution.setSkipped(executionCounter.getSkipped().toString());
                    statisticsCounters.setExecutions(execution);
                }
                if ((issueCounter = statistics.getIssueCounter()) != null) {
                    com.epam.ta.reportportal.ws.model.statistics.IssueCounter issues = new com.epam.ta.reportportal.ws.model.statistics.IssueCounter();
                    issues.setProductBug(issueCounter.getProductBug());
                    issues.setSystemIssue(issueCounter.getSystemIssue());
                    issues.setAutomationBug(issueCounter.getAutomationBug());
                    issues.setToInvestigate(issueCounter.getToInvestigate());
                    issues.setNoDefect(issueCounter.getNoDefect());
                    statisticsCounters.setDefects(issues);
                }
                resource.setStatistics(statisticsCounters);
            }
        }
        return this;
    }

    protected LaunchResource initObject() {
        return new LaunchResource();
    }
}

