/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.database.entity.BinaryContent;
import com.epam.ta.reportportal.database.entity.Log;
import com.epam.ta.reportportal.ws.converter.builders.ResourceBuilder;
import com.epam.ta.reportportal.ws.model.log.LogResource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class LogResourceBuilder
extends ResourceBuilder<LogResource> {
    protected LogResource initObject() {
        return new LogResource();
    }

    public LogResourceBuilder addLog(Log log) {
        LogResource resource = (LogResource)this.getObject();
        resource.setIdLog(log.getId());
        if (null != log.getLogMsg()) {
            resource.setMessage(log.getLogMsg());
        } else {
            resource.setMessage("NULL");
        }
        resource.setLogTime(log.getLogTime());
        BinaryContent binaryData = log.getBinaryContent();
        if (null != binaryData) {
            LogResource.BinaryContent binaryContent = new LogResource.BinaryContent();
            binaryContent.setBinaryDataId(binaryData.getBinaryDataId());
            binaryContent.setContentType(binaryData.getContentType());
            binaryContent.setThumbnailId(binaryData.getThumbnailId());
            resource.setBinaryContent(binaryContent);
        }
        resource.setTestItem(log.getTestItemRef());
        if (null != log.getLevel()) {
            resource.setLevel(log.getLevel().toString());
        }
        return this;
    }
}

