/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.commons.SendCase;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.ProjectSpecific;
import com.epam.ta.reportportal.database.entity.StatisticsCalculationStrategy;
import com.epam.ta.reportportal.database.entity.project.EntryType;
import com.epam.ta.reportportal.database.entity.project.InterruptionJobDelay;
import com.epam.ta.reportportal.database.entity.project.KeepLogsDelay;
import com.epam.ta.reportportal.database.entity.project.KeepScreenshotsDelay;
import com.epam.ta.reportportal.ws.converter.builders.Builder;
import com.epam.ta.reportportal.ws.model.project.CreateProjectRQ;
import com.epam.ta.reportportal.ws.model.project.email.EmailSenderCase;
import com.epam.ta.reportportal.ws.model.project.email.ProjectEmailConfig;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class ProjectBuilder
extends Builder<Project> {
    public ProjectBuilder addCreateProjectRQ(CreateProjectRQ createProjectRQ) {
        if (createProjectRQ != null) {
            ((Project)this.getObject()).setName(createProjectRQ.getProjectName().trim());
            ((Project)this.getObject()).setCreationDate(new Date());
            ((Project)this.getObject()).getConfiguration().setEntryType((EntryType)EntryType.findByName((String)createProjectRQ.getEntryType()).orElse(null));
            if (null != createProjectRQ.getCustomer()) {
                ((Project)this.getObject()).setCustomer(createProjectRQ.getCustomer().trim());
            }
            if (null != createProjectRQ.getAddInfo()) {
                ((Project)this.getObject()).setAddInfo(createProjectRQ.getAddInfo().trim());
            }
            ((Project)this.getObject()).getConfiguration().setExternalSystem(new ArrayList());
            ((Project)this.getObject()).getConfiguration().setProjectSpecific(ProjectSpecific.DEFAULT);
            ((Project)this.getObject()).getConfiguration().setInterruptJobTime(InterruptionJobDelay.ONE_DAY.getValue());
            ((Project)this.getObject()).getConfiguration().setKeepLogs(KeepLogsDelay.THREE_MONTHS.getValue());
            ((Project)this.getObject()).getConfiguration().setKeepScreenshots(KeepScreenshotsDelay.TWO_WEEKS.getValue());
            ((Project)this.getObject()).getConfiguration().setIsAutoAnalyzerEnabled(false);
            ((Project)this.getObject()).getConfiguration().setStatisticsCalculationStrategy(StatisticsCalculationStrategy.TEST_BASED);
            EmailSenderCase defaultOne = new EmailSenderCase((List)Lists.newArrayList((Object[])new String[]{"OWNER"}), SendCase.ALWAYS.name(), (List)Lists.newArrayList(), (List)Lists.newArrayList());
            ProjectEmailConfig config = new ProjectEmailConfig(false, "reportportal@example.com", (List)Lists.newArrayList((Object[])new EmailSenderCase[]{defaultOne}));
            ((Project)this.getObject()).getConfiguration().setEmailConfig(config);
            ((Project)this.getObject()).setUsers(new HashMap());
        }
        return this;
    }

    protected Project initObject() {
        return new Project();
    }
}

