/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.database.entity.ExternalSystem;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.ws.converter.builders.ResourceBuilder;
import com.epam.ta.reportportal.ws.model.externalsystem.ExternalSystemResource;
import com.epam.ta.reportportal.ws.model.project.ProjectConfiguration;
import com.epam.ta.reportportal.ws.model.project.ProjectResource;
import com.epam.ta.reportportal.ws.model.project.config.IssueSubTypeResource;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class ProjectResourceBuilder
extends ResourceBuilder<ProjectResource> {
    public ProjectResourceBuilder addProject(Project prj, Iterable<ExternalSystem> systems) {
        ProjectResource resource = (ProjectResource)this.getObject();
        resource.setProjectId(prj.getId());
        resource.setCustomer(prj.getCustomer());
        resource.setAddInfo(prj.getAddInfo());
        resource.setCreationDate(prj.getCreationDate());
        HashMap users = new HashMap();
        Map actualUsers = prj.getUsers();
        for (Map.Entry user : actualUsers.entrySet()) {
            ProjectResource.ProjectUser one = new ProjectResource.ProjectUser();
            one.setProjectRole(((Project.UserConfig)user.getValue()).getProjectRole().name());
            one.setProposedRole(((Project.UserConfig)user.getValue()).getProposedRole().name());
            users.put(user.getKey(), one);
        }
        resource.setUsers(users);
        if (null != prj.getConfiguration()) {
            ProjectConfiguration configuration = new ProjectConfiguration();
            ArrayList externalDetails = Lists.newArrayList();
            if (null != prj.getConfiguration().getEntryType()) {
                configuration.setEntry(prj.getConfiguration().getEntryType().name());
            }
            if (null != prj.getConfiguration().getProjectSpecific()) {
                configuration.setProjectSpecific(prj.getConfiguration().getProjectSpecific().name());
            }
            if (null != prj.getConfiguration().getKeepLogs()) {
                configuration.setKeepLogs(prj.getConfiguration().getKeepLogs());
            }
            if (null != prj.getConfiguration().getInterruptJobTime()) {
                configuration.setInterruptJobTime(prj.getConfiguration().getInterruptJobTime());
            }
            if (null != prj.getConfiguration().getKeepScreenshots()) {
                configuration.setKeepScreenshots(prj.getConfiguration().getKeepScreenshots());
            }
            if (null != prj.getConfiguration().getIsAutoAnalyzerEnabled()) {
                configuration.setIsAAEnabled(prj.getConfiguration().getIsAutoAnalyzerEnabled().booleanValue());
            }
            if (null != prj.getConfiguration().getStatisticsCalculationStrategy()) {
                configuration.setStatisticCalculationStrategy(prj.getConfiguration().getStatisticsCalculationStrategy().name());
            }
            configuration.setEmailConfig(prj.getConfiguration().getEmailConfig());
            if (null != prj.getConfiguration().getSubTypes()) {
                HashMap result = new HashMap();
                prj.getConfiguration().getSubTypes().forEach((k, v) -> {
                    ArrayList subTypeResources = Lists.newArrayList();
                    v.stream().forEach(subType -> subTypeResources.add(new IssueSubTypeResource(subType.getLocator(), subType.getTypeRef(), subType.getLongName(), subType.getShortName(), subType.getHexColor())));
                    result.put(k.getValue(), subTypeResources);
                });
                configuration.setSubTypes(result);
            }
            for (ExternalSystem system : systems) {
                ExternalSystemResource details = new ExternalSystemResource();
                details.setSystemId(system.getId());
                details.setUrl(system.getUrl());
                details.setExternalSystemType(system.getExternalSystemType().name());
                details.setExternalSystemAuth(system.getExternalSystemAuth().name());
                details.setUsername(system.getUsername());
                if (null != system.getProject()) {
                    details.setProject(system.getProject());
                }
                if (null != system.getDomain()) {
                    details.setDomain(system.getDomain());
                }
                if (null != system.getAccessKey()) {
                    details.setAccessKey(system.getAccessKey());
                }
                details.setFields(system.getFields());
                externalDetails.add(details);
            }
            configuration.setExternalSystem((List)externalDetails);
            resource.setConfiguration(configuration);
        }
        return this;
    }

    protected ProjectResource initObject() {
        return new ProjectResource();
    }
}

