/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.database.entity.ServerSettings;
import com.epam.ta.reportportal.ws.converter.builders.ResourceBuilder;
import com.epam.ta.reportportal.ws.model.settings.ServerEmailConfig;
import com.epam.ta.reportportal.ws.model.settings.ServerSettingsResource;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class ServerSettingsResourceBuilder
extends ResourceBuilder<ServerSettingsResource> {
    public ServerSettingsResourceBuilder addServerSettings(ServerSettings doc) {
        ServerSettingsResource resource = (ServerSettingsResource)this.getObject();
        resource.setProfile(doc.getId());
        resource.setActive(doc.getActive());
        ServerEmailConfig output = new ServerEmailConfig();
        output.setHost(doc.getServerEmailConfig().getHost());
        output.setPort(doc.getServerEmailConfig().getPort());
        output.setProtocol(doc.getServerEmailConfig().getProtocol());
        output.setAuthEnabled(doc.getServerEmailConfig().getAuthEnabled());
        output.setSslEnabled(doc.getServerEmailConfig().isSslEnabled());
        output.setStarTlsEnabled(doc.getServerEmailConfig().isStarTlsEnabled());
        if (doc.getServerEmailConfig().getAuthEnabled().booleanValue()) {
            output.setUsername(doc.getServerEmailConfig().getUsername());
        }
        resource.setServerEmailConfig(output);
        return this;
    }

    protected ServerSettingsResource initObject() {
        return new ServerSettingsResource();
    }
}

