/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.issue.TestItemIssue;
import com.epam.ta.reportportal.database.entity.statistics.IssueCounter;
import com.epam.ta.reportportal.database.entity.statistics.Statistics;
import com.epam.ta.reportportal.ws.converter.builders.ResourceBuilder;
import com.epam.ta.reportportal.ws.model.TestItemResource;
import com.epam.ta.reportportal.ws.model.issue.Issue;
import com.epam.ta.reportportal.ws.model.statistics.ExecutionCounter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class TestItemResourceBuilder
extends ResourceBuilder<TestItemResource> {
    protected TestItemResource initObject() {
        return new TestItemResource();
    }

    public TestItemResourceBuilder addTestItem(TestItem item, String launchStatus) {
        if (item == null) {
            return this;
        }
        TestItemResource resource = (TestItemResource)this.getObject();
        resource.setDescription(item.getItemDescription());
        resource.setTags(item.getTags());
        resource.setEndTime(item.getEndTime());
        resource.setItemId(item.getId());
        TestItemIssue testItemIssue = item.getIssue();
        if (null != testItemIssue) {
            Issue issue = new Issue();
            issue.setIssueType(testItemIssue.getIssueType());
            issue.setComment(testItemIssue.getIssueDescription());
            Set externalSystemIssues = testItemIssue.getExternalSystemIssues();
            if (null != externalSystemIssues) {
                HashSet<Issue.ExternalSystemIssue> issuesResource = new HashSet<Issue.ExternalSystemIssue>();
                for (TestItemIssue.ExternalSystemIssue externalSystemIssue : externalSystemIssues) {
                    Issue.ExternalSystemIssue issueResource = new Issue.ExternalSystemIssue();
                    issueResource.setSubmitDate(externalSystemIssue.getSubmitDate());
                    issueResource.setTicketId(externalSystemIssue.getTicketId());
                    issueResource.setSubmitter(externalSystemIssue.getSubmitter());
                    issueResource.setExternalSystemId(externalSystemIssue.getExternalSystemId());
                    issueResource.setUrl(externalSystemIssue.getUrl());
                    issuesResource.add(issueResource);
                }
                issue.setExternalSystemIssues(issuesResource);
            }
            resource.setIssue(issue);
        }
        resource.setName(item.getName());
        resource.setStartTime(item.getStartTime());
        resource.setStatus(item.getStatus() != null ? item.getStatus().toString() : null);
        resource.setType(item.getType() != null ? item.getType().name() : null);
        resource.setParent(item.getParent() != null ? item.getParent() : null);
        resource.setHasChilds(item.hasChilds());
        resource.setLaunchStatus(launchStatus);
        resource.setLaunchId(item.getLaunchRef());
        Statistics statistics = item.getStatistics();
        if (statistics != null) {
            IssueCounter issueCounter;
            com.epam.ta.reportportal.ws.model.statistics.Statistics statisticsCounters = new com.epam.ta.reportportal.ws.model.statistics.Statistics();
            com.epam.ta.reportportal.database.entity.statistics.ExecutionCounter executionCounter = statistics.getExecutionCounter();
            if (executionCounter != null) {
                ExecutionCounter execution = new ExecutionCounter();
                execution.setTotal(executionCounter.getTotal().toString());
                execution.setPassed(executionCounter.getPassed().toString());
                execution.setFailed(executionCounter.getFailed().toString());
                execution.setSkipped(executionCounter.getSkipped().toString());
                statisticsCounters.setExecutions(execution);
            }
            if ((issueCounter = statistics.getIssueCounter()) != null) {
                com.epam.ta.reportportal.ws.model.statistics.IssueCounter issues = new com.epam.ta.reportportal.ws.model.statistics.IssueCounter();
                issues.setProductBug(issueCounter.getProductBug());
                issues.setSystemIssue(issueCounter.getSystemIssue());
                issues.setAutomationBug(issueCounter.getAutomationBug());
                issues.setToInvestigate(issueCounter.getToInvestigate());
                issues.setNoDefect(issueCounter.getNoDefect());
                statisticsCounters.setDefects(issues);
            }
            resource.setStatistics(statisticsCounters);
        }
        return this;
    }

    public TestItemResourceBuilder addPathNames(Map<String, String> pathNames) {
        ((TestItemResource)this.getObject()).setPathNames(pathNames);
        return this;
    }
}

