/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.FilterCondition;
import com.epam.ta.reportportal.ws.converter.builders.ResourceBuilder;
import com.epam.ta.reportportal.ws.model.filter.SelectionParameters;
import com.epam.ta.reportportal.ws.model.filter.UserFilterEntity;
import com.epam.ta.reportportal.ws.model.filter.UserFilterResource;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class UserFilterResourceBuilder
extends ResourceBuilder<UserFilterResource> {
    protected UserFilterResource initObject() {
        return new UserFilterResource();
    }

    public UserFilterResourceBuilder addUserFilter(UserFilter userFilter) {
        if (userFilter != null) {
            ((UserFilterResource)this.getObject()).setFilterId(userFilter.getId());
            ((UserFilterResource)this.getObject()).setName(userFilter.getName());
            ((UserFilterResource)this.getObject()).setDescription(userFilter.getDescription());
            Filter filter = userFilter.getFilter();
            if (filter != null) {
                ((UserFilterResource)this.getObject()).setObjectType(filter.getTarget().getSimpleName().toLowerCase());
                ((UserFilterResource)this.getObject()).setEntities(this.transformFilterEntities(filter));
            }
            if (null != userFilter.getSelectionOptions()) {
                SelectionParameters selectionParameters = new SelectionParameters();
                selectionParameters.setSortingColumnName(userFilter.getSelectionOptions().getSortingColumnName());
                selectionParameters.setIsAsc(userFilter.getSelectionOptions().isAsc());
                selectionParameters.setPageNumber(userFilter.getSelectionOptions().getPageNumber());
                ((UserFilterResource)this.getObject()).setSelectionParameters(selectionParameters);
            }
            if (null != userFilter.getAcl()) {
                ((UserFilterResource)this.getObject()).setOwner(userFilter.getAcl().getOwnerUserId());
                ((UserFilterResource)this.getObject()).setIsShared(!userFilter.getAcl().getEntries().isEmpty());
            }
        }
        return this;
    }

    private Set<UserFilterEntity> transformFilterEntities(Filter filterEntities) {
        LinkedHashSet<UserFilterEntity> result = new LinkedHashSet<UserFilterEntity>();
        for (FilterCondition filterCondition : filterEntities.getFilterConditions()) {
            UserFilterEntity userFilterEntity = new UserFilterEntity();
            if (filterCondition.getCondition() != null) {
                userFilterEntity.setCondition(filterCondition.getCondition().getMarker());
            }
            userFilterEntity.setIsNegative(filterCondition.isNegative());
            userFilterEntity.setValue(filterCondition.getValue());
            userFilterEntity.setFilteringField(filterCondition.getSearchCriteria());
            result.add(userFilterEntity);
        }
        return result;
    }
}

