/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.ws.converter.builders;

import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.entity.user.UserType;
import com.epam.ta.reportportal.database.personal.PersonalProjectUtils;
import com.epam.ta.reportportal.ws.converter.builders.ResourceBuilder;
import com.epam.ta.reportportal.ws.model.user.UserResource;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class UserResourceBuilder
extends ResourceBuilder<UserResource> {
    @Autowired
    private ProjectRepository projectRepository;
    private static Comparator<Project> PROJECT_NAME_ALPHABET = (prj1, prj2) -> {
        int res = String.CASE_INSENSITIVE_ORDER.compare(prj1.getName(), prj2.getName());
        if (res == 0) {
            res = prj1.getName().compareTo(prj2.getName());
        }
        return res;
    };

    public UserResourceBuilder addUser(User user) {
        if (null != user) {
            return this.addUser(user, this.projectRepository.findUserProjects(user.getLogin()));
        }
        return this;
    }

    private UserResourceBuilder addUser(User user, List<Project> projects) {
        if (user != null) {
            UserResource resource = (UserResource)this.getObject();
            resource.setUserId(user.getLogin());
            resource.setEmail(user.getEmail());
            resource.setPhotoId(user.getPhotoId());
            resource.setFullName(user.getFullName());
            resource.setAccountType(user.getType().toString());
            resource.setUserRole(user.getRole().toString());
            resource.setLastlogin(user.getMetaInfo().getLastLogin());
            resource.setIsLoaded(UserType.UPSA != user.getType());
            if (projects.size() > 1) {
                Collections.sort(projects, PROJECT_NAME_ALPHABET);
            }
            LinkedHashMap<String, UserResource.AssignedProject> userProjects = new LinkedHashMap<String, UserResource.AssignedProject>(projects.size());
            for (Project project : projects) {
                UserResource.AssignedProject assignedProject = new UserResource.AssignedProject();
                Project.UserConfig userConfig = (Project.UserConfig)project.getUsers().get(user.getId());
                assignedProject.setProjectRole(userConfig.getProjectRole().name());
                assignedProject.setProposedRole(userConfig.getProposedRole().name());
                assignedProject.setEntryType(project.getConfiguration().getEntryType().name());
                userProjects.put(project.getId(), assignedProject);
            }
            resource.setAssignedProjects(userProjects);
            if (userProjects.containsKey(user.getDefaultProject())) {
                resource.setDefaultProject(user.getDefaultProject());
            } else {
                resource.setDefaultProject(PersonalProjectUtils.personalProjectName((String)user.getId()));
            }
        }
        return this;
    }

    protected UserResource initObject() {
        return new UserResource();
    }
}

