/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.reportportal.commons.template.FreemarkerTemplateEngine;
import com.epam.reportportal.commons.template.TemplateEngine;
import com.epam.ta.reportportal.database.dao.ServerSettingsRepository;
import com.epam.ta.reportportal.util.email.MailServiceFactory;
import com.google.common.base.Charsets;
import freemarker.template.TemplateExceptionHandler;
import freemarker.template.Version;
import java.util.Locale;
import org.jasypt.util.text.BasicTextEncryptor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class EmailConfiguration {
    @Bean
    public MailServiceFactory initializeEmailServiceFactory(TemplateEngine templateEngine, BasicTextEncryptor encryptor, ServerSettingsRepository settingsRepository) {
        return new MailServiceFactory(templateEngine, encryptor, settingsRepository);
    }

    @Bean
    public TemplateEngine getTemplateEngine() {
        Version version = new Version(2, 3, 25);
        freemarker.template.Configuration cfg = new freemarker.template.Configuration(version);
        cfg.setClassForTemplateLoading(EmailConfiguration.class, "/templates/email");
        cfg.setIncompatibleImprovements(version);
        cfg.setDefaultEncoding(Charsets.UTF_8.toString());
        cfg.setLocale(Locale.US);
        cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        return new FreemarkerTemplateEngine(cfg);
    }
}

