/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.configs;

import com.epam.ta.reportportal.core.configs.Conditions;
import com.epam.ta.reportportal.core.configs.Swagger2Configuration;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.security.Principal;
import java.util.Collections;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import springfox.documentation.PathProvider;
import springfox.documentation.builders.RequestHandlerSelectors;
import springfox.documentation.schema.TypeNameExtractor;
import springfox.documentation.service.ApiInfo;
import springfox.documentation.service.Contact;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spring.web.paths.RelativePathProvider;
import springfox.documentation.spring.web.plugins.Docket;
import springfox.documentation.swagger.web.UiConfiguration;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

@Configuration
@Conditional(value={Conditions.NotTestCondition.class})
@EnableSwagger2
@ComponentScan(basePackages={"com.epam.ta.reportportal.ws.controller"})
public class Swagger2Configuration {
    @Autowired
    private ServletContext servletContext;
    @Autowired
    @Value(value="${spring.application.name}")
    private String eurekaName;
    @Autowired
    @Value(value="${info.build.version}")
    private String buildVersion;

    @Bean
    public Docket docket() {
        ApiInfo rpInfo = new ApiInfo("Report Portal", "Report Portal API documentation", this.buildVersion, "urn:tos", new Contact("EPAM Systems", "http://epam.com", "Support EPMC-TST Report Portal <SupportEPMC-TSTReportPortal@epam.com>"), "GPLv3", "https://www.gnu.org/licenses/licenses.html#GPL", Collections.emptyList());
        Docket rpDocket = new Docket(DocumentationType.SWAGGER_2).ignoredParameterTypes(new Class[]{Principal.class}).pathProvider(this.rpPathProvider()).useDefaultResponseMessages(false).ignoredParameterTypes(new Class[]{UserRole.class}).select().apis(Predicates.not((Predicate)Predicates.or((Predicate)RequestHandlerSelectors.basePackage((String)"org.springframework.boot"), (Predicate)RequestHandlerSelectors.basePackage((String)"org.springframework.cloud")))).build();
        rpDocket.apiInfo(rpInfo);
        return rpDocket;
    }

    @Bean
    public PathProvider rpPathProvider() {
        return new RelativePathProvider(this.servletContext);
    }

    @Bean
    PageableParameterBuilderPlugin pageableParameterBuilderPlugin(TypeNameExtractor nameExtractor, TypeResolver resolver) {
        return new PageableParameterBuilderPlugin(nameExtractor, resolver);
    }

    @Bean(name={"multipartResolver"})
    public CommonsMultipartResolver commonsMultipartResolver() {
        return new CommonsMultipartResolver();
    }

    @Bean
    public UiConfiguration uiConfig() {
        return new UiConfiguration(null);
    }
}

