/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.externalsystem;

import com.epam.ta.reportportal.commons.Preconditions;
import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.commons.validation.Suppliers;
import com.epam.ta.reportportal.core.externalsystem.ExternalSystemEurekaDelegate;
import com.epam.ta.reportportal.core.externalsystem.ExternalSystemStrategy;
import com.epam.ta.reportportal.database.entity.item.issue.ExternalSystemType;
import com.epam.ta.reportportal.ws.model.ErrorType;
import java.util.Optional;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class StrategyProvider {
    @Autowired
    private ExternalSystemEurekaDelegate externalSystemStrategy;

    public ExternalSystemStrategy getStrategy(String externalSystemName) {
        Optional externalSystem = ExternalSystemType.findByName((String)externalSystemName);
        this.validate(externalSystem, externalSystemName);
        this.externalSystemStrategy.checkAvailable((ExternalSystemType)externalSystem.get());
        return this.externalSystemStrategy;
    }

    private void validate(Optional<ExternalSystemType> externalSystem, String externalSystemName) {
        BusinessRule.expect(externalSystem, (Predicate)Preconditions.IS_PRESENT).verify(ErrorType.INCORRECT_EXTERNAL_SYSTEM_NAME, new Object[]{Suppliers.formattedSupplier((String)"Unknown external system '{}'.", (Object[])new Object[]{externalSystemName})});
        BusinessRule.expect((Object)externalSystem.get(), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)ExternalSystemType.NONE))).verify(ErrorType.UNABLE_INTERACT_WITH_EXTRERNAL_SYSTEM, new Object[]{Suppliers.formattedSupplier((String)"External system is not defined in project settings.", (Object[])new Object[]{externalSystemName})});
    }
}

