/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.filter.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.acl.AclUtils;
import com.epam.ta.reportportal.core.filter.IDeleteUserFilterHandler;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.UserFilterRepository;
import com.epam.ta.reportportal.database.entity.filter.UserFilter;
import com.epam.ta.reportportal.database.entity.sharing.Acl;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import java.io.Serializable;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DeleteUserFilterHandler
implements IDeleteUserFilterHandler {
    private final UserFilterRepository filterRepository;
    private final ProjectRepository projectRepository;

    @Autowired
    public DeleteUserFilterHandler(UserFilterRepository filterRepository, ProjectRepository projectRepository) {
        this.filterRepository = filterRepository;
        this.projectRepository = projectRepository;
    }

    public OperationCompletionRS deleteFilter(String filterId, String userName, String projectName, UserRole userRole) {
        UserFilter userFilter = (UserFilter)this.filterRepository.findOne((Serializable)((Object)filterId));
        BusinessRule.expect((Object)userFilter, (Predicate)Predicates.notNull()).verify(ErrorType.USER_FILTER_NOT_FOUND, new Object[]{filterId, userName});
        AclUtils.isAllowedToEdit((Acl)userFilter.getAcl(), (String)userName, (Map)this.projectRepository.findProjectRoles(userName), (String)userFilter.getName(), (UserRole)userRole);
        BusinessRule.expect((Object)userFilter.getProjectName(), (Predicate)Predicates.equalTo((Object)projectName)).verify(ErrorType.ACCESS_DENIED, new Object[0]);
        try {
            this.filterRepository.delete((Serializable)((Object)filterId));
        }
        catch (Exception e) {
            throw new ReportPortalException("Error during deleting complex filter item", (Throwable)e);
        }
        OperationCompletionRS response = new OperationCompletionRS();
        StringBuilder msg = new StringBuilder("User filter with ID = '");
        msg.append(filterId);
        msg.append("' successfully deleted.");
        response.setResultMessage(msg.toString());
        return response;
    }
}

