/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.imprt.impl.junit;

import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.imprt.impl.DateUtils;
import com.epam.ta.reportportal.core.imprt.impl.ImportStrategy;
import com.epam.ta.reportportal.core.imprt.impl.junit.JunitParseJob;
import com.epam.ta.reportportal.core.imprt.impl.junit.ParseResults;
import com.epam.ta.reportportal.core.launch.IFinishLaunchHandler;
import com.epam.ta.reportportal.core.launch.IStartLaunchHandler;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.entity.Launch;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.FinishExecutionRQ;
import com.epam.ta.reportportal.ws.model.launch.Mode;
import com.epam.ta.reportportal.ws.model.launch.StartLaunchRQ;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class AsyncJunitImportStrategy
implements ImportStrategy {
    @Autowired
    private Provider<JunitParseJob> xmlParseJobProvider;
    @Autowired
    private IStartLaunchHandler startLaunchHandler;
    @Autowired
    private IFinishLaunchHandler finishLaunchHandler;
    @Autowired
    private LaunchRepository launchRepository;
    private static final Date initialStartTime = new Date(0L);
    private static final ExecutorService service = Executors.newFixedThreadPool(5);
    private static final String XML_REGEX = ".*xml";
    private static final String ZIP_REGEX = ".*zip";
    private static final Predicate<ZipEntry> isFile = zipEntry -> !zipEntry.isDirectory();
    private static final Predicate<ZipEntry> isXml = zipEntry -> zipEntry.getName().matches(XML_REGEX);

    public String importLaunch(String projectId, String userName, MultipartFile file) {
        try {
            BusinessRule.expect((Object)file.getOriginalFilename(), it -> it.matches(ZIP_REGEX)).verify(ErrorType.BAD_IMPORT_FILE_TYPE, new Object[]{file.getOriginalFilename()});
            File tmp = File.createTempFile(file.getOriginalFilename(), ".zip");
            file.transferTo(tmp);
            return this.processZipFile(tmp, projectId, userName);
        }
        catch (IOException e) {
            throw new ReportPortalException(ErrorType.BAD_IMPORT_FILE_TYPE, new Object[]{file.getOriginalFilename(), e});
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String processZipFile(File zip, String projectId, String userName) throws IOException {
        try (ZipFile zipFile = new ZipFile(zip);){
            String launchId = this.startLaunch(projectId, userName, zip.getName().substring(0, zip.getName().indexOf(".zip")));
            CompletableFuture[] futures = (CompletableFuture[])zipFile.stream().filter(isFile.and(isXml)).map(zipEntry -> {
                try {
                    JunitParseJob job = ((JunitParseJob)this.xmlParseJobProvider.get()).withParameters(projectId, launchId, userName, zipFile.getInputStream((ZipEntry)zipEntry));
                    return CompletableFuture.supplyAsync(() -> ((JunitParseJob)job).call(), service);
                }
                catch (IOException e) {
                    throw new ReportPortalException("There was a problem while parsing file : " + zipEntry.getName(), (Throwable)e);
                }
            }).toArray(CompletableFuture[]::new);
            CompletableFuture.allOf(futures).get(5L, TimeUnit.MINUTES);
            this.finishLaunch(launchId, projectId, userName, this.processResults(futures));
            String string = launchId;
            return string;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new ReportPortalException(ErrorType.BAD_IMPORT_FILE_TYPE, new Object[]{"There are invalid xml files inside.", e});
        }
    }

    private ParseResults processResults(CompletableFuture[] futures) {
        ParseResults results = new ParseResults();
        Arrays.stream(futures).map(it -> (ParseResults)it.join()).forEach(res -> {
            results.checkAndSetStartLaunchTime(res.getStartTime());
            results.increaseDuration(res.getDuration());
        });
        return results;
    }

    private String startLaunch(String projectId, String userName, String launchName) {
        StartLaunchRQ startLaunchRQ = new StartLaunchRQ();
        startLaunchRQ.setStartTime(initialStartTime);
        startLaunchRQ.setName(launchName);
        startLaunchRQ.setMode(Mode.DEFAULT);
        return this.startLaunchHandler.startLaunch(userName, projectId, startLaunchRQ).getId();
    }

    private void finishLaunch(String launchId, String projectId, String userName, ParseResults results) {
        FinishExecutionRQ finishExecutionRQ = new FinishExecutionRQ();
        finishExecutionRQ.setEndTime(results.getEndTime());
        this.finishLaunchHandler.finishLaunch(launchId, finishExecutionRQ, projectId, userName);
        Launch launch = (Launch)this.launchRepository.findOne((Serializable)((Object)launchId));
        launch.setStartTime(DateUtils.toDate((LocalDateTime)results.getStartTime()));
        this.launchRepository.partialUpdate((Object)launch);
    }
}

