/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.imprt.impl.junit;

import com.epam.ta.reportportal.core.imprt.impl.junit.JunitImportHandler;
import com.epam.ta.reportportal.core.imprt.impl.junit.ParseResults;
import com.epam.ta.reportportal.exception.ReportPortalException;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.Callable;
import javax.inject.Provider;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class JunitParseJob
implements Callable<ParseResults> {
    @Autowired
    private Provider<JunitImportHandler> junitImportHandlerProvider;
    private JunitImportHandler handler;
    private InputStream xmlInputStream;

    @Override
    public ParseResults call() {
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(this.xmlInputStream, (DefaultHandler)this.handler);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ReportPortalException("Xml parse job problem.", (Throwable)e);
        }
        return new ParseResults(this.handler.getStartSuiteTime(), this.handler.getCommonDuration());
    }

    JunitParseJob withParameters(String projectId, String launchId, String user, InputStream xmlInputStream) {
        this.xmlInputStream = xmlInputStream;
        this.handler = ((JunitImportHandler)this.junitImportHandlerProvider.get()).withParameters(projectId, launchId, user);
        return this;
    }
}

