/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.user.impl;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.user.IEditUserHandler;
import com.epam.ta.reportportal.core.user.event.UpdateUserRoleEvent;
import com.epam.ta.reportportal.core.user.event.UpdatedRole;
import com.epam.ta.reportportal.core.user.impl.CreateUserHandler;
import com.epam.ta.reportportal.database.BinaryData;
import com.epam.ta.reportportal.database.DataStorage;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.dao.UserRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.project.ProjectUtils;
import com.epam.ta.reportportal.database.entity.user.ImageFormat;
import com.epam.ta.reportportal.database.entity.user.User;
import com.epam.ta.reportportal.database.entity.user.UserRole;
import com.epam.ta.reportportal.database.entity.user.UserType;
import com.epam.ta.reportportal.database.entity.user.UserUtils;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.OperationCompletionRS;
import com.epam.ta.reportportal.ws.model.user.ChangePasswordRQ;
import com.epam.ta.reportportal.ws.model.user.EditUserRQ;
import com.google.common.base.Charsets;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.imageio.ImageIO;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class EditUserHandler
implements IEditUserHandler {
    private UserRepository userRepository;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private ApplicationEventPublisher eventPublisher;
    @Autowired
    private DataStorage dataStorage;

    @Autowired
    public void setUserRepository(UserRepository userRepository) {
        this.userRepository = userRepository;
    }

    public OperationCompletionRS editUser(String username, EditUserRQ editUserRQ, UserRole userRole) {
        return this.editUser(username, editUserRQ, userRole == UserRole.ADMINISTRATOR);
    }

    public OperationCompletionRS uploadPhoto(String username, MultipartFile file) {
        try {
            this.validatePhoto(file);
            BinaryData binaryData = new BinaryData(file.getContentType(), Long.valueOf(file.getSize()), file.getInputStream());
            this.userRepository.replaceUserPhoto(username, binaryData);
        }
        catch (IOException e) {
            BusinessRule.fail().withError(ErrorType.BINARY_DATA_CANNOT_BE_SAVED, new Object[0]);
        }
        return new OperationCompletionRS("Profile photo has been uploaded successfully");
    }

    public OperationCompletionRS deletePhoto(String login) {
        User user = this.userRepository.findOne(login);
        BusinessRule.expect((Object)user.getType(), (Predicate)Predicates.equalTo((Object)UserType.INTERNAL)).verify(ErrorType.ACCESS_DENIED, new Object[]{"Unable to change photo for external user"});
        if (null != user.getPhotoId()) {
            this.dataStorage.deleteData(user.getPhotoId());
        }
        return new OperationCompletionRS("Profile photo has been deleted successfully");
    }

    public OperationCompletionRS changePassword(String userName, ChangePasswordRQ changePasswordRQ) {
        User user = this.userRepository.findOne(userName);
        BusinessRule.expect((Object)user.getType(), (Predicate)Predicates.equalTo((Object)UserType.INTERNAL)).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Impossible to change password for external users."});
        BusinessRule.expect((Object)user.getPassword(), (Predicate)Predicates.equalTo((Object)CreateUserHandler.HASH_FUNCTION.hashString((CharSequence)changePasswordRQ.getOldPassword(), Charsets.UTF_8).toString())).verify(ErrorType.FORBIDDEN_OPERATION, new Object[]{"Old password not match with stored."});
        user.setPassword(CreateUserHandler.HASH_FUNCTION.hashString((CharSequence)changePasswordRQ.getNewPassword(), Charsets.UTF_8).toString());
        this.userRepository.save(user);
        return new OperationCompletionRS("Password has been changed successfully");
    }

    private OperationCompletionRS editUser(String username, EditUserRQ editUserRQ, boolean isAdmin) {
        User user = this.userRepository.findOne(username);
        BusinessRule.expect((Object)user, (Predicate)Predicates.notNull()).verify(ErrorType.USER_NOT_FOUND, new Object[]{username});
        boolean isRoleChanged = false;
        UpdatedRole source = null;
        if (null != editUserRQ.getRole() && isAdmin) {
            Optional newRole = UserRole.findByName((String)editUserRQ.getRole());
            BusinessRule.expect((Object)newRole.isPresent(), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{"Incorrect specified Account Role parameter."});
            user.setRole((UserRole)newRole.get());
            source = new UpdatedRole(username, (UserRole)newRole.get());
            isRoleChanged = true;
        }
        if (null != editUserRQ.getDefaultProject()) {
            Project def = (Project)this.projectRepository.findOne((Serializable)((Object)editUserRQ.getDefaultProject().toLowerCase()));
            BusinessRule.expect((Object)def, (Predicate)Predicates.notNull()).verify(ErrorType.PROJECT_NOT_FOUND, new Object[]{editUserRQ.getDefaultProject()});
            user.setDefaultProject(editUserRQ.getDefaultProject());
        }
        if (null != editUserRQ.getEmail()) {
            String updEmail = editUserRQ.getEmail().toLowerCase().trim();
            BusinessRule.expect((Object)user.getType(), (Predicate)Predicates.equalTo((Object)UserType.INTERNAL)).verify(ErrorType.ACCESS_DENIED, new Object[]{"Unable to change email for external user"});
            BusinessRule.expect((Object)UserUtils.isEmailValid((String)updEmail), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{" wrong email: " + updEmail});
            User byEmail = this.userRepository.findByEmail(updEmail);
            if (null != byEmail) {
                BusinessRule.expect((Object)username, (Predicate)Predicates.equalTo((Object)byEmail.getId())).verify(ErrorType.USER_ALREADY_EXISTS, new Object[]{updEmail});
            }
            BusinessRule.expect((Object)UserUtils.isEmailValid((String)updEmail), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BAD_REQUEST_ERROR, new Object[]{updEmail});
            List userProjects = this.projectRepository.findUserProjects(username);
            userProjects.forEach(project -> ProjectUtils.updateProjectRecipients((String)user.getEmail(), (String)updEmail, (Project)project));
            user.setEmail(updEmail);
            try {
                this.projectRepository.save((Iterable)userProjects);
            }
            catch (Exception exp) {
                throw new ReportPortalException("PROJECT update exception while USER editing.", (Throwable)exp);
            }
        }
        if (null != editUserRQ.getFullName()) {
            BusinessRule.expect((Object)user.getType(), (Predicate)Predicates.equalTo((Object)UserType.INTERNAL)).verify(ErrorType.ACCESS_DENIED, new Object[]{"Unable to change full name for external user"});
            user.setFullName(editUserRQ.getFullName());
        }
        try {
            this.userRepository.save(user);
            if (isRoleChanged) {
                this.eventPublisher.publishEvent((ApplicationEvent)new UpdateUserRoleEvent(source));
            }
        }
        catch (Exception exp) {
            throw new ReportPortalException("Error while User editing.", (Throwable)exp);
        }
        return new OperationCompletionRS("User with login = '" + user.getLogin() + "' successfully updated");
    }

    private void validatePhoto(MultipartFile file) throws IOException {
        BusinessRule.expect((Object)(file.getSize() < 0x100000L ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BINARY_DATA_CANNOT_BE_SAVED, new Object[]{"Image size should be less than 1 mb"});
        MediaType mediaType = new AutoDetectParser().getDetector().detect((InputStream)TikaInputStream.get((byte[])file.getBytes()), new Metadata());
        String subtype = mediaType.getSubtype();
        BusinessRule.expect((Object)ImageFormat.fromValue((String)subtype), (Predicate)Predicates.notNull()).verify(ErrorType.BINARY_DATA_CANNOT_BE_SAVED, new Object[]{"Image format should be " + ImageFormat.getValues()});
        BufferedImage read = ImageIO.read(file.getInputStream());
        BusinessRule.expect((Object)(read.getHeight() <= 500 && read.getWidth() <= 300 ? 1 : 0), (Predicate)Predicates.equalTo((Object)true)).verify(ErrorType.BINARY_DATA_CANNOT_BE_SAVED, new Object[]{"Image size should be 300x500px or less"});
    }
}

