/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.core.widget.content;

import com.epam.ta.reportportal.commons.Predicates;
import com.epam.ta.reportportal.commons.validation.BusinessRule;
import com.epam.ta.reportportal.core.widget.content.IContentLoadingStrategy;
import com.epam.ta.reportportal.core.widget.content.StatisticBasedContentLoader;
import com.epam.ta.reportportal.database.StatisticsDocumentHandler;
import com.epam.ta.reportportal.database.dao.LaunchRepository;
import com.epam.ta.reportportal.database.search.Filter;
import com.epam.ta.reportportal.database.search.Queryable;
import com.epam.ta.reportportal.ws.model.ErrorType;
import com.epam.ta.reportportal.ws.model.widget.ChartObject;
import com.google.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.mongodb.core.DocumentCallbackHandler;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service(value="LineChartContentLoader")
public class LineChartContentLoader
extends StatisticBasedContentLoader
implements IContentLoadingStrategy {
    @Autowired
    private LaunchRepository launchRepository;

    @SuppressFBWarnings(value={"NP_NULL_PARAM_DEREF"})
    public Map<String, List<ChartObject>> loadContent(Filter filter, Sort sorting, int quantity, List<String> contentFields, List<String> metaDataFields, Map<String, List<String>> options) {
        BusinessRule.expect((Object)(metaDataFields == null || metaDataFields.isEmpty() ? 1 : 0), (Predicate)Predicates.equalTo((Object)Boolean.FALSE)).verify(ErrorType.UNABLE_LOAD_WIDGET_CONTENT, new Object[]{"Metadata fields should exist for providing content."});
        ImmutableList allFields = ImmutableList.builder().addAll(contentFields).addAll(metaDataFields).build();
        StatisticsDocumentHandler handler = new StatisticsDocumentHandler(contentFields, metaDataFields);
        String collectionName = LineChartContentLoader.getCollectionName((Class)filter.getTarget());
        this.launchRepository.loadWithCallback((Queryable)filter, sorting, quantity, (List)allFields, (DocumentCallbackHandler)handler, collectionName);
        if (options.get("timeline") != null && StatisticBasedContentLoader.Period.findByName((String)options.get("timeline").get(0)) != null) {
            return this.groupByDate(handler.getResult(), StatisticBasedContentLoader.Period.findByName((String)options.get("timeline").get(0)));
        }
        return Collections.singletonMap("result", handler.getResult());
    }
}

