/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demo_data;

import com.epam.ta.reportportal.database.BinaryData;
import com.epam.ta.reportportal.database.DataStorage;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.entity.BinaryContent;
import com.epam.ta.reportportal.database.entity.Log;
import com.epam.ta.reportportal.database.entity.LogLevel;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.demo_data.Attachment;
import com.epam.ta.reportportal.demo_data.ContentUtils;
import com.epam.ta.reportportal.exception.ReportPortalException;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.SplittableRandom;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;

@Service
class DemoLogsService {
    private SplittableRandom random;
    private LogRepository logRepository;
    private DataStorage dataStorage;
    private static final int MIN_LOGS_COUNT = 5;
    private static final int MAX_LOGS_COUNT = 30;
    private static final int BINARY_CONTENT_PROBABILITY = 20;

    @Autowired
    DemoLogsService(DataStorage dataStorage, LogRepository logRepository) {
        this.dataStorage = dataStorage;
        this.logRepository = logRepository;
        this.random = new SplittableRandom();
    }

    List<Log> generateDemoLogs(String itemId, String status) {
        int logsCount = this.random.nextInt(5, 30);
        List logs = IntStream.range(1, logsCount).mapToObj(it -> {
            Log log = new Log();
            log.setLevel(this.logLevel());
            log.setLogTime(new Date());
            if (ContentUtils.getWithProbability((int)20)) {
                log.setBinaryContent(this.attachBinaryContent());
            }
            log.setTestItemRef(itemId);
            log.setLogMsg(ContentUtils.getLogMessage());
            return log;
        }).collect(Collectors.toList());
        if (Status.FAILED.name().equals(status)) {
            List errors = ContentUtils.getErrorLogs();
            logs.addAll(errors.stream().map(msg -> {
                Log log = new Log();
                log.setLevel(LogLevel.ERROR);
                log.setLogTime(new Date());
                log.setTestItemRef(itemId);
                log.setLogMsg(msg);
                BinaryContent binaryContent = this.attachBinaryContent();
                log.setBinaryContent(binaryContent);
                return log;
            }).collect(Collectors.toList()));
        }
        return this.logRepository.save(logs);
    }

    private BinaryContent attachBinaryContent() {
        try {
            Attachment attachment = this.randomAttachment();
            String file = this.saveResource(attachment.getContentType(), attachment.getResource());
            if (attachment.equals((Object)Attachment.PNG)) {
                String thumbnail = this.saveResource(attachment.getContentType(), new ClassPathResource("demo/attachments/img_tn.png"));
                return new BinaryContent(file, thumbnail, attachment.getContentType());
            }
            return new BinaryContent(file, file, attachment.getContentType());
        }
        catch (IOException e) {
            throw new ReportPortalException("Unable to save binary data", (Throwable)e);
        }
    }

    private String saveResource(String contentType, ClassPathResource resource) throws IOException {
        return this.dataStorage.saveData(new BinaryData(contentType, Long.valueOf(resource.contentLength()), resource.getInputStream()), resource.getFilename());
    }

    private Attachment randomAttachment() {
        return Attachment.values()[this.random.nextInt(Attachment.values().length)];
    }

    private LogLevel logLevel() {
        int i = this.random.nextInt(50);
        if (i < 10) {
            return LogLevel.DEBUG;
        }
        if (i < 20) {
            return LogLevel.WARN;
        }
        if (i < 30) {
            return LogLevel.TRACE;
        }
        return LogLevel.INFO;
    }
}

