/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.demo_data;

import com.epam.ta.reportportal.database.entity.StatisticsCalculationStrategy;
import com.epam.ta.reportportal.database.entity.Status;
import com.epam.ta.reportportal.database.entity.item.TestItem;
import com.epam.ta.reportportal.database.entity.item.TestItemType;
import com.epam.ta.reportportal.demo_data.ContentUtils;
import com.epam.ta.reportportal.demo_data.DemoDataCommonService;
import com.epam.ta.reportportal.demo_data.DemoDataFacade;
import com.epam.ta.reportportal.demo_data.DemoDataRq;
import com.epam.ta.reportportal.exception.ReportPortalException;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class TestBasedDemoDataFacade
extends DemoDataCommonService
implements DemoDataFacade {
    private static final StatisticsCalculationStrategy strategy = StatisticsCalculationStrategy.TEST_BASED;
    @Value(value="classpath:demo/demo_bdd.json")
    private Resource resource;

    public List<String> generateDemoLaunches(DemoDataRq rq, String user, String projectName) {
        Map stories;
        try {
            stories = (Map)this.objectMapper.readValue(this.resource.getURL(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IOException e) {
            throw new ReportPortalException("Unable to load stories description. " + e.getMessage(), (Throwable)e);
        }
        return this.generateLaunches(rq, stories, user, projectName);
    }

    private List<String> generateLaunches(DemoDataRq rq, Map<String, Map<String, List<String>>> storiesStructure, String user, String project) {
        return IntStream.range(0, rq.getLaunchesQuantity()).mapToObj(i -> {
            String launchId = this.startLaunch("Demo Api Tests_" + rq.getPostfix(), i, project, user);
            boolean hasBeforeAfterStories = ContentUtils.getWithProbability((int)30);
            if (hasBeforeAfterStories) {
                this.finishRootItem(this.startRootItem("BeforeStories", launchId, TestItemType.STORY).getId());
            }
            this.generateStories(storiesStructure, i, launchId);
            if (hasBeforeAfterStories) {
                this.finishRootItem(this.startRootItem("AfterStories", launchId, TestItemType.STORY).getId());
            }
            this.finishLaunch(launchId);
            return launchId;
        }).collect(Collectors.toList());
    }

    private List<String> generateStories(Map<String, Map<String, List<String>>> storiesStructure, int i, String launchId) {
        List<String> stories = storiesStructure.entrySet().stream().limit(i + 1).map(story -> {
            TestItem storyItem = this.startRootItem((String)story.getKey(), launchId, TestItemType.STORY);
            ((Map)story.getValue()).entrySet().forEach(scenario -> {
                if (ContentUtils.getWithProbability((int)30)) {
                    this.finishTestItem(this.startTestItem(storyItem, launchId, "beforeScenario", TestItemType.SCENARIO).getId(), this.status(), strategy);
                }
                TestItem scenarioItem = this.startTestItem(storyItem, launchId, (String)scenario.getKey(), TestItemType.SCENARIO);
                boolean isFailed = false;
                for (String step : (List)scenario.getValue()) {
                    String status;
                    TestItem stepItem = this.startTestItem(scenarioItem, launchId, step, TestItemType.STEP);
                    if (isFailed) {
                        status = Status.SKIPPED.name();
                    } else {
                        status = this.status();
                        if (Status.FAILED.name().equalsIgnoreCase(status) || Status.SKIPPED.name().equalsIgnoreCase(status)) {
                            isFailed = true;
                        }
                    }
                    this.logDemoDataService.generateDemoLogs(stepItem.getId(), status);
                    this.finishTestItem(stepItem.getId(), status, strategy);
                }
                this.finishTestItem(scenarioItem.getId(), isFailed ? Status.FAILED.name() : Status.PASSED.name(), strategy);
                if (ContentUtils.getWithProbability((int)30)) {
                    this.finishTestItem(this.startTestItem(storyItem, launchId, "afterScenario", TestItemType.SCENARIO).getId(), this.status(), strategy);
                }
            });
            this.finishRootItem(storyItem.getId());
            return storyItem.getId();
        }).collect(Collectors.toList());
        if (ContentUtils.getWithProbability((int)30)) {
            stories.add(this.generateCustomStory(launchId));
        }
        return stories;
    }

    private String generateCustomStory(String launchId) {
        TestItem outerStory = this.startRootItem("Complex story with given inner story", launchId, TestItemType.STORY);
        TestItem innerStory = this.startTestItem(outerStory, launchId, "Given Story", TestItemType.STORY);
        TestItem innerScenario = this.startTestItem(innerStory, launchId, "A given story scenario", TestItemType.SCENARIO);
        TestItem innerStep = this.startTestItem(innerScenario, launchId, "Today has 'a' and 'y' in its name", TestItemType.STEP);
        TestItem outerScenario = this.startTestItem(outerStory, launchId, "Simple Scenario", TestItemType.SCENARIO);
        TestItem outerStep = this.startTestItem(outerScenario, launchId, "Simple Step", TestItemType.STEP);
        this.logDemoDataService.generateDemoLogs(innerStep.getId(), Status.PASSED.name());
        this.logDemoDataService.generateDemoLogs(outerStep.getId(), Status.FAILED.name());
        this.finishTestItem(outerStep.getId(), Status.FAILED.name(), strategy);
        this.finishTestItem(outerScenario.getId(), Status.FAILED.name(), strategy);
        this.finishTestItem(innerStep.getId(), Status.PASSED.name(), strategy);
        this.finishTestItem(innerScenario.getId(), Status.PASSED.name(), strategy);
        this.finishTestItem(innerStory.getId(), Status.PASSED.name(), strategy);
        this.finishRootItem(outerStory.getId());
        return outerStory.getId();
    }
}

