/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.entity.Project;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.events.EmailConfigUpdatedEvent;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import com.epam.ta.reportportal.ws.converter.converters.EmailConfigConverters;
import com.epam.ta.reportportal.ws.model.project.email.ProjectEmailConfigDTO;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class ProjectEmailUpdatedHandler {
    private static final String UPDATE_PROJECT = "update_project";
    private static final String EMAIL_STATUS = "emailEnabled";
    private static final String EMAIL_CASES = "emailCases";
    private static final String EMAIL_FROM = "from";
    private final ActivityRepository activityRepository;
    private final Provider<ActivityBuilder> activityBuilder;

    @Autowired
    public ProjectEmailUpdatedHandler(ActivityRepository activityRepository, Provider<ActivityBuilder> activityBuilder) {
        this.activityRepository = activityRepository;
        this.activityBuilder = activityBuilder;
    }

    @EventListener
    public void onProjectEmailUpdate(EmailConfigUpdatedEvent event) {
        HashMap history = new HashMap();
        ProjectEmailConfigDTO configuration = event.getUpdateProjectEmailRQ().getConfiguration();
        if (null != configuration) {
            this.processEmailConfiguration(history, (Project)event.getBefore(), configuration);
        }
        if (!history.isEmpty()) {
            Activity activityLog = (Activity)((ActivityBuilder)this.activityBuilder.get()).addProjectRef(((Project)event.getBefore()).getName()).addObjectType("project").addActionType(UPDATE_PROJECT).addUserRef(event.getUpdatedBy()).build();
            activityLog.setHistory(history);
            this.activityRepository.save((Object)activityLog);
        }
    }

    private void processEmailConfiguration(Map<String, Activity.FieldValues> history, Project project, ProjectEmailConfigDTO configuration) {
        boolean isEmailCasesChanged;
        boolean isEmailOptionChanged = configuration.getEmailEnabled() != null && !configuration.getEmailEnabled().equals(project.getConfiguration().getEmailConfig().getEmailEnabled());
        boolean isEmailFromChanged = null != configuration.getFrom() && !configuration.getFrom().equalsIgnoreCase(project.getConfiguration().getEmailConfig().getFrom());
        ProjectEmailConfigDTO builtProjectEmailConfig = (ProjectEmailConfigDTO)EmailConfigConverters.TO_RESOURCE.apply(project.getConfiguration().getEmailConfig());
        boolean bl = isEmailCasesChanged = null != configuration.getEmailCases() && !configuration.getEmailCases().equals(builtProjectEmailConfig.getEmailCases());
        if (isEmailOptionChanged) {
            Activity.FieldValues fieldValues = Activity.FieldValues.newOne().withOldValue(String.valueOf(project.getConfiguration().getEmailConfig().getEmailEnabled())).withNewValue(String.valueOf(configuration.getEmailEnabled()));
            history.put(EMAIL_STATUS, fieldValues);
        } else {
            if (isEmailCasesChanged) {
                history.put(EMAIL_CASES, null);
            }
            if (isEmailFromChanged) {
                Activity.FieldValues fieldValues = Activity.FieldValues.newOne().withOldValue(String.valueOf(project.getConfiguration().getEmailConfig().getFrom())).withNewValue(String.valueOf(configuration.getFrom()));
                history.put(EMAIL_FROM, fieldValues);
            }
        }
    }
}

