/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.events.handler;

import com.epam.ta.reportportal.database.dao.ActivityRepository;
import com.epam.ta.reportportal.database.entity.item.Activity;
import com.epam.ta.reportportal.events.UserCreatedEvent;
import com.epam.ta.reportportal.ws.converter.builders.ActivityBuilder;
import javax.inject.Provider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Component;

@Component
public class UserActivityHandler {
    public static final String CREATE_USER = "create_user";
    private final ActivityRepository activityRepository;
    private final Provider<ActivityBuilder> activityBuilder;

    @Autowired
    public UserActivityHandler(ActivityRepository activityRepository, Provider<ActivityBuilder> activityBuilder) {
        this.activityRepository = activityRepository;
        this.activityBuilder = activityBuilder;
    }

    @EventListener
    public void onUserCreated(UserCreatedEvent event) {
        Activity activity = (Activity)((ActivityBuilder)this.activityBuilder.get()).addActionType(CREATE_USER).addLoggedObjectRef(event.getUser().getLogin()).addObjectName(event.getUser().getLogin()).addObjectType("user").addUserRef(event.getCreatedBy()).addProjectRef(event.getUser().getDefaultProject().toLowerCase()).build();
        this.activityRepository.save((Object)activity);
    }
}

