/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.ta.reportportal.database.DataStorage;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.dao.ProjectRepository;
import com.epam.ta.reportportal.database.entity.project.KeepScreenshotsDelay;
import java.time.Duration;
import java.util.stream.Stream;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class CleanScreenshotsJob
implements Runnable {
    @Autowired
    private DataStorage gridFS;
    @Autowired
    private ProjectRepository projectRepository;
    @Autowired
    private LogRepository logRepository;

    @Override
    @Scheduled(cron="${com.ta.reportportal.job.clean.screenshots.cron}")
    public void run() {
        try (Stream projects = this.projectRepository.streamAllIdsAndConfiguration();){
            projects.forEach(project -> this.gridFS.findModifiedLaterAgo(Duration.ofDays(KeepScreenshotsDelay.findByName((String)project.getConfiguration().getKeepScreenshots()).getDays()), project.getId()).forEach(file -> {
                this.gridFS.deleteData(file.getId().toString());
                this.logRepository.removeBinaryContent(file.getId().toString());
            }));
        }
    }
}

