/*
 * Decompiled with CFR 0.152.
 */
package com.epam.ta.reportportal.job;

import com.epam.reportportal.commons.Thumbnailator;
import com.epam.ta.reportportal.database.BinaryData;
import com.epam.ta.reportportal.database.DataStorage;
import com.epam.ta.reportportal.database.dao.LogRepository;
import com.epam.ta.reportportal.database.entity.BinaryContent;
import com.epam.ta.reportportal.database.entity.Log;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SaveBinaryDataJob
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(SaveBinaryDataJob.class);
    @Autowired
    private LogRepository logRepository;
    @Autowired
    private DataStorage dataStorageService;
    @Autowired
    private Thumbnailator thumbnailator;
    private String filename;
    private BinaryData binaryData;
    private String project;
    private Log log;

    @Override
    public void run() {
        String thumbnailId = null;
        Map<String, String> metadata = Collections.singletonMap("project", this.project);
        if (this.isImage(this.binaryData)) {
            try {
                byte[] image = IOUtils.toByteArray((InputStream)this.binaryData.getInputStream());
                byte[] thumbnailBytes = this.thumbnailator.createThumbnail(image);
                thumbnailId = this.dataStorageService.saveData(new BinaryData(this.binaryData.getContentType(), Long.valueOf(thumbnailBytes.length), (InputStream)new ByteArrayInputStream(thumbnailBytes)), "thumbnail-".concat(this.filename), metadata);
                this.binaryData = new BinaryData(this.binaryData.getContentType(), this.binaryData.getLength(), (InputStream)new ByteArrayInputStream(image));
            }
            catch (IOException e) {
                LOGGER.error("Thumbnail is not created for log [{}]. Error:\n{}", (Object)this.log.getId(), (Object)e);
            }
        }
        String dataId = this.dataStorageService.saveData(this.binaryData, this.filename, metadata);
        BinaryContent content = new BinaryContent();
        content.setBinaryDataId(dataId);
        content.setContentType(this.binaryData.getContentType());
        if (null != thumbnailId) {
            content.setThumbnailId(thumbnailId);
        }
        this.log.setBinaryContent(content);
        this.logRepository.save((Object)this.log);
    }

    public SaveBinaryDataJob withBinaryData(BinaryData binaryData) {
        Preconditions.checkNotNull((Object)binaryData, (Object)"Binary data shouldn't be null");
        this.binaryData = binaryData;
        return this;
    }

    public SaveBinaryDataJob withLog(Log log) {
        Preconditions.checkNotNull((Object)log, (Object)"Log shouldn't be null");
        this.log = log;
        return this;
    }

    public SaveBinaryDataJob withFilename(String filename) {
        Preconditions.checkNotNull((Object)filename, (Object)"Filename shouldn't be null");
        this.filename = filename;
        return this;
    }

    public SaveBinaryDataJob withProject(String projectName) {
        Preconditions.checkNotNull((Object)projectName, (Object)"Project name shouldn't be null");
        this.project = projectName;
        return this;
    }

    private boolean isImage(BinaryData binaryData) {
        return binaryData.getContentType() != null && binaryData.getContentType().contains("image");
    }
}

